/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUISubsystem;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderMainPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private LoaderGUISubsystem subs;
    private JLabel controlRealHardware;
    private FilterPanel filterPanel1;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private LoaderClampPanel loaderClampPanel;

    public LoaderMainPanel() {
        this.initComponents();
    }

    public LoaderMainPanel(LoaderGUISubsystem subs) {
        this.subs = subs;
        this.initComponents();
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return this.loaderClampPanel;
    }

    public void initializeGui(LoaderConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        SwingUtilities.invokeLater(new UpdateCarrier(statusDataPublishedByLoaderCarrier));
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.loaderClampPanel = new LoaderClampPanel();
        this.jPanel1 = new JPanel();
        this.filterPanel1 = new FilterPanel();
        this.controlRealHardware = new JLabel();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.loaderClampPanel.setLoaderSubsystem(this.subs);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.loaderClampPanel, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        GroupLayout filterPanel1Layout = new GroupLayout(this.filterPanel1);
        this.filterPanel1.setLayout(filterPanel1Layout);
        filterPanel1Layout.setHorizontalGroup(filterPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        filterPanel1Layout.setVerticalGroup(filterPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.filterPanel1, gridBagConstraints);
        this.controlRealHardware.setFont(new Font("Lucida Grande", 1, 14));
        this.controlRealHardware.setText("controlRealHardware");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.controlRealHardware, gridBagConstraints);
    }

    private class GuiInitialization
    implements Runnable {
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
            LoaderMainPanel.this.controlRealHardware.setText(this.loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");
        }

        @Override
        public void run() {
            LoaderClampConfig loaderClampConfig = this.loaderConfig.getLoaderClampConfig();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.openHooksTimeout = loaderClampConfig.getTimeoutToOpen();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.closeHooksTimeout = loaderClampConfig.getTimeoutToClose();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.clampHooksTimeout = loaderClampConfig.getTimeoutToClamp();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.homingHooksTimeout = loaderClampConfig.getTimeoutToGoHome();
        }
    }

    class UpdateCarrier
    implements Runnable {
        StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
        }
    }

    class UpdateClamp
    implements Runnable {
        StatusDataPublishedByLoaderClamp s;

        UpdateClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            this.s.getClampState();
            LoaderMainPanel.this.loaderClampPanel.updateClamp(this.s);
        }
    }
}

