/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.ui.Carousel;
import org.lsst.ccs.subsystems.fcs.ui.CarouselModel;
import org.lsst.ccs.subsystems.fcs.ui.CarouselModelTestPanel;

public class CarouselGUISubsystem
extends Subsystem {
    private final CarouselModel model = new CarouselModel();

    CarouselGUISubsystem() {
        Carousel carousel = new Carousel();
        carousel.setModel(this.model);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)carousel, "Center");
        panel.add((Component)new CarouselModelTestPanel(this.model), "South");
        JFrame frame = new JFrame("Carousel Demo");
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        CarouselGUISubsystem t = new CarouselGUISubsystem();
        t.setName("CarouselGUIModule");
        t.setListenToStatus(true);
        t.setStatusBroadcastPeriod(0);
        t.start();
    }

    public void onStatus(BusMessage s) {
        System.out.println("CarouselGUI got:" + s);
        if (s instanceof TrendingStatus) {
            TrendingStatus v = (TrendingStatus)s;
            ValueNotification dt = (ValueNotification)v.getValue();
            String cfr_ignored_0 = String.valueOf(s.getOrigin()) + "_" + dt.getName();
            dt.gettStamp();
            Object value = dt.getData();
            if (value instanceof StatusDataPublishedByCarousel) {
                final StatusDataPublishedByCarousel status = (StatusDataPublishedByCarousel)value;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CarouselGUISubsystem.this.model.setFilterInCamera(status.getFilterInStandbyName());
                        CarouselGUISubsystem.this.model.setRotationInDegrees((float)status.getRotationInDegrees());
                        CarouselGUISubsystem.this.model.setLocked(status.isLocked());
                    }
                });
            }
        }
    }
}

