/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.clamp;

import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;

public class ClampsTableModel
extends DefaultTableModel {
    static final String[] colNames = new String[]{"Clamp Name", "Clamp State", "Lock Sensor Status", "Lock Sensor Value", "Lock Sensor Limits", "Filter Status", "Filter Position", "Filter Position Limits"};
    static final Class[] colTypes = new Class[]{String.class, String.class, String.class, Double.class, String.class, String.class, Double.class, String.class};

    public ClampsTableModel() {
        super(colNames, 0);
    }

    public Class getColumnClass(int columnIndex) {
        return colTypes[columnIndex];
    }

    void addClamp(ClampConfig clampConfig) {
        this.addRow(new Object[]{clampConfig.getName(), "", "", 0, String.valueOf(clampConfig.getLockSensorValueA()) + " - " + clampConfig.getLockSensorValueB(), "", 0, String.valueOf(clampConfig.getFilterPositionValueA()) + " - " + clampConfig.getFilterPositionValueB() + " - " + clampConfig.getFilterPositionValueC()});
    }

    public void updateClampStatus(StatusDataPublishedByClamp status) {
        int rows = this.getRowCount();
        int i = 0;
        while (i < rows) {
            if (this.getValueAt(i, 0).equals(status.getName())) {
                this.setValueAt(status.getFilterPositionInClamp(), i, 5);
                this.setValueAt(status.getFilterPositionSensorValue(), i, 6);
                this.setValueAt(status.getClampState(), i, 1);
                this.setValueAt(status.getLockStatus(), i, 2);
                this.setValueAt(status.getLockSensorValue(), i, 3);
                return;
            }
            ++i;
        }
    }
}

