package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.*;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;

import javax.swing.*;
import java.io.PrintWriter;

/**
 *
 * @author max
 */
public class SingleFilterTestGUISubsystem extends Subsystem {

    private static final String sft_dest = "single-filter-test";
    private PrintWriter out = new PrintWriter(System.out, true);
//    private SingleFilterTestAssembly assembly;
      private FilterExchangeMainPanel assembly;
//    private CarouselTablePanel carouselTable;
//    private RefrigControlPanel panel;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean initialized = false;
    String stateCorrelId;

    public SingleFilterTestGUISubsystem() {
//        assembly = new SingleFilterTestAssembly(this);
        assembly = new FilterExchangeMainPanel(this);
//        carouselTable = assembly.getCarouselTable();
//        panel = assembly.getControlPanel();
    }

    public void initGui() {
        setName("SingleFilterTestGUIModule");
        setListenToStatus(true);
        setStatusBroadcastPeriod(0);
        start();

//        Timer t = new Timer();
//        t.scheduleAtFixedRate(new TimerTask() {
//
//            @Override
//            public void run() {
//                long delta = (System.currentTimeMillis() - lastHeartBeat) / 1000;
//                if (initialized && delta > 10) {
//                    panel.disableSystem();
//                }
//            }
//        }, new Date(), 5000);
    }

    public JComponent getGuiLayout() {
        return assembly;
    }

    public void resetGui() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        System.setProperty("java.naming.factory.initial",
                "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs",
                "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state",
                "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost",
                args.length >= 1 ? args[0] : "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");

//        Properties props = FrameworkUtils.loadProperties(FrameworkUtils.getDefaultJndiProperties(),RefrigGUISubsystem.class.getClass(),"jndi.properties");

        SingleFilterTestGUISubsystem t = new SingleFilterTestGUISubsystem();

        JFrame frame = new JFrame("Single Filter Test Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(false);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            
            SingleFilterTestConfig config = (SingleFilterTestConfig) s.getReply();
            assembly.initializeGui(config);
//            carouselTable.createTableRows(config);
//            panel.updateControlPanel(r.getRefrigState());
            initialized = true;
        }
    }

    @Override
    public void onStatus(BusMessage s) {
        
//        System.out.println("*** Got status message "+s.getClass());

        if (initialized) {
            if (s instanceof StatusDataPublishedByClamp) {
                assembly.updateClamp((StatusDataPublishedByClamp) s);
                lastHeartBeat = s.getTimeStamp();
            } else if ( s instanceof StatusDataPublishedByBasicAutoChanger ) {
                assembly.updateAutoChanger((StatusDataPublishedByBasicAutoChanger)s);
                lastHeartBeat = s.getTimeStamp();
            } else if ( s instanceof StatusDataPublishedByLatch ) {
                assembly.updateLatch((StatusDataPublishedByLatch)s);
                lastHeartBeat = s.getTimeStamp();
            } else if ( s instanceof StatusDataPublishedByCarousel ) {
                assembly.updateCarousel((StatusDataPublishedByCarousel)s);
                lastHeartBeat = s.getTimeStamp();
            } else if ( s instanceof StatusDataPublishedByClampActuator ) {
                assembly.updateActuator((StatusDataPublishedByClampActuator)s);
                lastHeartBeat = s.getTimeStamp();                
            }
            //else
            //    System.out.println("****** "+s.getClass());
            
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }
    }

//    public void submitLimit(int index, double value, boolean isLowLimit) {
//        Integer arg1 = index;
//        Double arg2 = value;
//        String command = isLowLimit ? "setLowLimit" : "setHighLimit";
//        sendCommand(new ModuleInvokerCommand(command, arg1, arg2));
//    }
//
//    public void setPowerStatus(boolean enablePower) {
//        Integer arg = enablePower ? 1 : 0;
//        sendCommand(new ModuleInvokerCommand("setPowerEnable", arg));
//    }
//
//    public void setLoadTripStatus(boolean enableLoadTrip) {
//        Integer arg = enableLoadTrip ? 1 : 0;
//        sendCommand(new ModuleInvokerCommand("setLoadTripEnable", arg));
//    }
//
//    public void setTickMillis(int value) {
//        sendCommand(new ModuleInvokerCommand("setTickMillis", value));
//    }
//
//    public void saveConfiguration() {
//        sendCommand(new ModuleInvokerCommand("saveConfiguration"));
//    }
//
    private void sendCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(sft_dest);
        updateCurrentSubsystem();
        fac.sendCommand(cmd);
    }
}
