/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FilterExchangeMainPanel.java
 *
 * Created on Oct 3, 2012, 12:45:05 AM
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLatch;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch;

/**
 *
 * @author turri
 */
public class FilterExchangeMainPanel extends javax.swing.JPanel {

    /** Creates new form FilterExchangeMainPanel */
    public FilterExchangeMainPanel() {
        initComponents();
    }

    public FilterExchangeMainPanel(SingleFilterTestGUISubsystem subs) {
        initComponents();
        

        railSensorStandByPositionXminus.setColor(Color.gray);
        railSensorHandOffPositionXminus.setColor(Color.gray);
        railSensorHandOffPositionXplus.setColor(Color.gray);
        railSensorStandByPositionXplus.setColor(Color.gray);
        lockSensorPositionLatchXminus.setColor(Color.gray);
        unlockSensorPositionLatchXminus.setColor(Color.gray);
        filterPresenceSensorLatchXminus.setColor(Color.gray);
        filterPresenceSensorLatchXplus.setColor(Color.gray);
        unlockSensorPositionLatchXplus.setColor(Color.gray);
        lockSensorPositionLatchXplus.setColor(Color.gray);

        filterPositionInClampXMinusProgress.setValueAndColor(0,Color.gray);
        filterPositionInClampXPlusProgress.setValueAndColor(0,Color.gray);
        lockSensorStateClampXMinusProgress.setValueAndColor(0,Color.gray);
        lockSensorStateClampXPlusProgress.setValueAndColor(0,Color.gray);
        
        filterPositionInClampXPlusSwitch.setColor(Color.gray);
        filterPositionInClampXMinusSwitch.setColor(Color.gray);
        lockSensorStateClampXPlusSwitch.setColor(Color.gray);
        lockSensorStateClampXMinusSwitch.setColor(Color.gray);

        
        movementPanel.setStatus(false, false);
        
        Color backgroundColor = getBackground();
        latchActuatorCurrentMeterXplus.setBackground(backgroundColor);
        latchActuatorCurrentMeterXminus.setBackground(backgroundColor);
        clampActuatorCurrentMeterXplus.setBackground(backgroundColor);
        clampActuatorCurrentMeterXminus.setBackground(backgroundColor);
    }

    public void initializeGui(SingleFilterTestConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }

    public void updateClamp(StatusDataPublishedByClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateLatch(StatusDataPublishedByLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        SwingUtilities.invokeLater(new UpdateAutoChanger(status));
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        SwingUtilities.invokeLater(new UpdateCarousel(status));
    }
    
    public void updateActuator(StatusDataPublishedByClampActuator status) {
        SwingUtilities.invokeLater(new UpdateActuator(status));
    }
    
    class GuiInitialization implements Runnable {

        SingleFilterTestConfig s;

        GuiInitialization(SingleFilterTestConfig s) {
            this.s = s;
        }

        @Override
        public void run() {
            ClampConfig xMinusClampConfig = s.getClampXminusConfig();
            ClampConfig xPlusClampConfig = s.getClampXplusConfig();
            configureClampFilterPositionProgressBar(filterPositionInClampXMinusProgress, xMinusClampConfig);
            configureClampFilterPositionProgressBar(filterPositionInClampXPlusProgress, xPlusClampConfig);
            configureClampLockSensorProgressBar(lockSensorStateClampXMinusProgress, xMinusClampConfig);
            configureClampLockSensorProgressBar(lockSensorStateClampXPlusProgress, xPlusClampConfig);
            
            
            clampActuatorCurrentMeterXminus.setLimits(s.getClampActuatorXminus().getSentCurrentMinValue(), s.getClampActuatorXminus().getSentCurrentMaxValue());
            clampActuatorCurrentMeterXplus.setLimits(s.getClampActuatorXplus().getSentCurrentMinValue(), s.getClampActuatorXplus().getSentCurrentMaxValue());
            
            latchActuatorCurrentMeterXminus.setLimits(s.getLatchActuatorXminus().getSentCurrentMinValue(), s.getLatchActuatorXminus().getSentCurrentMaxValue());
            latchActuatorCurrentMeterXplus.setLimits(s.getLatchActuatorXplus().getSentCurrentMinValue(), s.getLatchActuatorXplus().getSentCurrentMaxValue());
            
        }
    }

    class UpdateActuator implements Runnable {

        StatusDataPublishedByClampActuator s;

        UpdateActuator(StatusDataPublishedByClampActuator s) {
            this.s = s;
        }

        @Override
        public void run() {
            String name = s.getName();
            AnalogMeter meter;
            if ( name.equals("clampActuatorXplus") )
                meter = clampActuatorCurrentMeterXplus;
            else if ( name.equals("clampActuatorXminus"))
                meter = clampActuatorCurrentMeterXminus;
            else if ( name.equals("latchActuatorXplus"))
                meter = latchActuatorCurrentMeterXminus;
            else if ( name.equals("latchActuatorXminus"))
                meter = latchActuatorCurrentMeterXplus;
            else
                throw new RuntimeException("Unknown actuator name "+name);
            
            meter.setValue(s.getSentValue());
            
        }
    }

    class UpdateAutoChanger implements Runnable {

        StatusDataPublishedByBasicAutoChanger s;

        UpdateAutoChanger(StatusDataPublishedByBasicAutoChanger s) {
            this.s = s;
        }

        @Override
        public void run() {

            filterInAutochangerPanel.setIsFilterInHouse( ! s.isTrucksEmpty() );
            railSensorHandOffPositionXminus.setColor( s.getRailSensorStandbackXminusValue() == 1 ? greenColor : Color.gray );
            railSensorHandOffPositionXplus.setColor( s.getRailSensorStandbackXplusValue() == 1 ? greenColor : Color.gray );
            railSensorStandByPositionXminus.setColor( s.getRailSensorStandbyXminusValue() == 1 ? greenColor : Color.gray );
            railSensorStandByPositionXplus.setColor( s.getRailSensorStandbyXplusValue() == 1 ? greenColor : Color.gray );
            
            movementPanel.setStatus(s.isMovingToStandback(), s.isMovingToStandby());
            
        }
    }

    class UpdateCarousel implements Runnable {

        StatusDataPublishedByCarousel s;

        UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            filterInCarouselPanel.setIsFilterInHouse( ! (s.getFilterInStandbyName().equals("none")) );
        }
    }
    
    class UpdateLatch implements Runnable {

        StatusDataPublishedByLatch s;

        UpdateLatch(StatusDataPublishedByLatch s) {
            this.s = s;
        }

        @Override
        public void run() {

            String name = s.getName();

            DigitalSwitch lockSensorSwitch = name.toLowerCase().contains("xminus") ? lockSensorPositionLatchXminus : lockSensorPositionLatchXplus;
            DigitalSwitch unlockSensorSwitch = name.toLowerCase().contains("xminus") ? unlockSensorPositionLatchXminus : unlockSensorPositionLatchXplus;
            DigitalSwitch filterPositionSensorSwitch = name.toLowerCase().contains("xminus") ? filterPresenceSensorLatchXminus : filterPresenceSensorLatchXplus;
            
            filterPositionSensorSwitch.setColor( s.getFilterPositionSensorValue() == 1 ? greenColor : Color.gray );

            int lockSensorValue = s.getLockSensorValue();
            int unlockSensorValue = s.getUnlockSensorValue();
            
            if ( lockSensorValue == unlockSensorValue && lockSensorValue == 1 ) {
                lockSensorSwitch.setColor( Color.red );
                unlockSensorSwitch.setColor( Color.red );
            } else {
                lockSensorSwitch.setColor( lockSensorValue == 1 ? greenColor : Color.gray );
                unlockSensorSwitch.setColor( unlockSensorValue == 1 ? greenColor : Color.gray );
            }

            
        }
    }
    
    
    class UpdateClamp implements Runnable {

        StatusDataPublishedByClamp s;

        UpdateClamp(StatusDataPublishedByClamp s) {
            this.s = s;
        }

        @Override
        public void run() {

            String clampState = s.getClampState();
            String filterPositionState = s.getFilterPositionInClamp();
            String lockSensorStatus = s.getLockStatus();

            int filterPositionValue = s.getFilterPositionSensorValue();
            int lockSensorValue = s.getLockSensorValue();

            String name = s.getName();

            HorizontalProgressBar lockSensorProgressBar = name.toLowerCase().contains("xminus") ? lockSensorStateClampXMinusProgress : lockSensorStateClampXPlusProgress;
            VerticalProgressBar filterPositionProgressBar = name.toLowerCase().contains("xminus") ? filterPositionInClampXMinusProgress : filterPositionInClampXPlusProgress;

            DigitalSwitch lockSensorSwitch = name.toLowerCase().contains("xminus") ? lockSensorStateClampXMinusSwitch : lockSensorStateClampXPlusSwitch;
            DigitalSwitch filterPositionSwitch = name.toLowerCase().contains("xminus") ? filterPositionInClampXMinusSwitch : filterPositionInClampXPlusSwitch;
            
            JLabel lockSensorLabel = name.toLowerCase().contains("xminus") ? lockSensorXMinusState : lockSensorXPlusState;
            JLabel filterPositionSensorLabel = name.toLowerCase().contains("xminus") ? positionSensorXMinusState : positionSensorXPlusState;

            
            Color lockSensorColor = getLockSensorColor(lockSensorStatus);
            lockSensorProgressBar.setValueAndColor( lockSensorValue, lockSensorColor );
            lockSensorSwitch.setColor(lockSensorColor);


            Color filterPositionColor = getFilterPresenceColor(filterPositionState);
            filterPositionProgressBar.setValueAndColor( filterPositionValue, filterPositionColor );
            filterPositionSwitch.setColor(filterPositionColor);
            
            lockSensorLabel.setText(lockSensorStatus);
            lockSensorLabel.setForeground(lockSensorColor);
            filterPositionSensorLabel.setText(filterPositionState);
            filterPositionSensorLabel.setForeground(filterPositionColor);
        }
    }
    private static Color greenColor = new Color(0, 165, 0);

    private static Color getLockSensorColor(String lockSensorStatus) {
        if (lockSensorStatus.equals(LockStatus.ERROR.toString())) {
            return Color.red;
        } else if (lockSensorStatus.equals(LockStatus.LOCKED.toString())) {
            return greenColor;
        } else if (lockSensorStatus.equals(LockStatus.UNKNOWN.toString())) {
            return Color.orange;
        } else if (lockSensorStatus.equals(LockStatus.UNLOCKED.toString())) {
            return Color.blue;
        } else {
            throw new IllegalArgumentException("Unknown Lock Sensor Status " + lockSensorStatus);
        }
    }

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.ENGAGED.toString())) {
            return greenColor;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.UNKNOWN.toString())) {
            return Color.orange;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        } else {
            throw new IllegalArgumentException("Unknown Filter Presence Status " + filterPresenceStatus);
        }
    }    
    
    private static void configureClampFilterPositionProgressBar(VerticalProgressBar progressBar, ClampConfig config) {
        progressBar.setValues(config.getFilterPositionMinValue(), config.getFilterPositionMaxValue(),
                config.getFilterPositionValueA(), config.getFilterPositionValueB(), config.getFilterPositionValueC());
    }

    private static void configureClampLockSensorProgressBar(HorizontalProgressBar progressBar, ClampConfig config) {
        progressBar.setValues(config.getFilterPositionMinValue(), config.getFilterPositionMaxValue(),
                config.getFilterPositionValueA(), config.getFilterPositionValueB(), config.getFilterPositionValueC());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel22 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        jLabel21 = new javax.swing.JLabel();
        jLabel25 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        railSensorStandByPositionXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        railSensorHandOffPositionXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        railSensorHandOffPositionXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        railSensorStandByPositionXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        jLabel32 = new javax.swing.JLabel();
        jLabel34 = new javax.swing.JLabel();
        jLabel35 = new javax.swing.JLabel();
        lockSensorPositionLatchXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        unlockSensorPositionLatchXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        filterPresenceSensorLatchXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        filterPresenceSensorLatchXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        unlockSensorPositionLatchXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        lockSensorPositionLatchXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        jLabel36 = new javax.swing.JLabel();
        jLabel37 = new javax.swing.JLabel();
        jLabel40 = new javax.swing.JLabel();
        lockSensorStateClampXPlusLabel = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        filterInAutochangerPanel = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel();
        filterInCarouselPanel = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel();
        movementPanel = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.MovementPanel();
        jLabel45 = new javax.swing.JLabel();
        jLabel46 = new javax.swing.JLabel();
        jLabel47 = new javax.swing.JLabel();
        jLabel33 = new javax.swing.JLabel();
        jLabel48 = new javax.swing.JLabel();
        jLabel24 = new javax.swing.JLabel();
        lockSensorStateClampXMinusSwitch = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        filterPositionInClampXMinusSwitch = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        filterPositionInClampXPlusSwitch = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        lockSensorStateClampXPlusSwitch = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        jLabel42 = new javax.swing.JLabel();
        filterPositionInClampXPlusLabel = new javax.swing.JLabel();
        lockSensorStateClampXMinusLabel = new javax.swing.JLabel();
        filterPositionInClampXMinusLabel = new javax.swing.JLabel();
        latchActuatorCurrentMeterXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter();
        latchActuatorCurrentMeterXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter();
        clampActuatorCurrentMeterXminus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter();
        clampActuatorCurrentMeterXplus = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter();
        jLabel38 = new javax.swing.JLabel();
        jLabel39 = new javax.swing.JLabel();
        filterPositionInClampXMinusProgress = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar();
        filterPositionInClampXMinusProgress.setPosition("left");
        filterPositionInClampXPlusProgress = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar();
        filterPositionInClampXMinusProgress.setPosition("right");
        lockSensorStateClampXMinusProgress = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar();
        lockSensorStateClampXMinusProgress.setPosition("left");
        lockSensorStateClampXPlusProgress = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar();
        lockSensorStateClampXMinusProgress.setPosition("right");
        positionSensorXPlusState = new javax.swing.JLabel();
        lockSensorXMinusState = new javax.swing.JLabel();
        lockSensorXPlusState = new javax.swing.JLabel();
        positionSensorXMinusState = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 18));
        jLabel1.setText("X-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 3;
        add(jLabel1, gridBagConstraints);

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 18));
        jLabel2.setText("X+");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 0;
        add(jLabel2, gridBagConstraints);

        jLabel22.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel22.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel22.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel22, gridBagConstraints);

        jLabel23.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel23.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel23.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        add(jLabel23, gridBagConstraints);

        jLabel21.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel21.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel21.setMaximumSize(new java.awt.Dimension(100, 2));
        jLabel21.setPreferredSize(null);
        jLabel21.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel21, gridBagConstraints);

        jLabel25.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel25.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel25.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        add(jLabel25, gridBagConstraints);

        jLabel11.setFont(new java.awt.Font("Tahoma", 1, 18));
        jLabel11.setText("X+");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 23;
        add(jLabel11, gridBagConstraints);

        jLabel20.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel20.setText("<html>Rail Sensor<br>Stand-back Position</html>");
        jLabel20.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 60, 0, 0);
        add(jLabel20, gridBagConstraints);

        javax.swing.GroupLayout railSensorStandByPositionXminusLayout = new javax.swing.GroupLayout(railSensorStandByPositionXminus);
        railSensorStandByPositionXminus.setLayout(railSensorStandByPositionXminusLayout);
        railSensorStandByPositionXminusLayout.setHorizontalGroup(
            railSensorStandByPositionXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorStandByPositionXminusLayout.setVerticalGroup(
            railSensorStandByPositionXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 13;
        add(railSensorStandByPositionXminus, gridBagConstraints);

        javax.swing.GroupLayout railSensorHandOffPositionXminusLayout = new javax.swing.GroupLayout(railSensorHandOffPositionXminus);
        railSensorHandOffPositionXminus.setLayout(railSensorHandOffPositionXminusLayout);
        railSensorHandOffPositionXminusLayout.setHorizontalGroup(
            railSensorHandOffPositionXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorHandOffPositionXminusLayout.setVerticalGroup(
            railSensorHandOffPositionXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.1;
        add(railSensorHandOffPositionXminus, gridBagConstraints);

        javax.swing.GroupLayout railSensorHandOffPositionXplusLayout = new javax.swing.GroupLayout(railSensorHandOffPositionXplus);
        railSensorHandOffPositionXplus.setLayout(railSensorHandOffPositionXplusLayout);
        railSensorHandOffPositionXplusLayout.setHorizontalGroup(
            railSensorHandOffPositionXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorHandOffPositionXplusLayout.setVerticalGroup(
            railSensorHandOffPositionXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        add(railSensorHandOffPositionXplus, gridBagConstraints);

        javax.swing.GroupLayout railSensorStandByPositionXplusLayout = new javax.swing.GroupLayout(railSensorStandByPositionXplus);
        railSensorStandByPositionXplus.setLayout(railSensorStandByPositionXplusLayout);
        railSensorStandByPositionXplusLayout.setHorizontalGroup(
            railSensorStandByPositionXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorStandByPositionXplusLayout.setVerticalGroup(
            railSensorStandByPositionXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        add(railSensorStandByPositionXplus, gridBagConstraints);

        jLabel32.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel32.setText("<html><P align=\"center\">Latch control<br>value</p></html>");
        jLabel32.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        add(jLabel32, gridBagConstraints);

        jLabel34.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel34.setText("<html><P align=\"center\">Lock<br>Position</p></html>");
        jLabel34.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 3);
        add(jLabel34, gridBagConstraints);

        jLabel35.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel35.setText("<html><P align=\"center\">Unlock<br>Position</p></html>");
        jLabel35.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        add(jLabel35, gridBagConstraints);

        javax.swing.GroupLayout lockSensorPositionLatchXminusLayout = new javax.swing.GroupLayout(lockSensorPositionLatchXminus);
        lockSensorPositionLatchXminus.setLayout(lockSensorPositionLatchXminusLayout);
        lockSensorPositionLatchXminusLayout.setHorizontalGroup(
            lockSensorPositionLatchXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorPositionLatchXminusLayout.setVerticalGroup(
            lockSensorPositionLatchXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(lockSensorPositionLatchXminus, gridBagConstraints);

        javax.swing.GroupLayout unlockSensorPositionLatchXminusLayout = new javax.swing.GroupLayout(unlockSensorPositionLatchXminus);
        unlockSensorPositionLatchXminus.setLayout(unlockSensorPositionLatchXminusLayout);
        unlockSensorPositionLatchXminusLayout.setHorizontalGroup(
            unlockSensorPositionLatchXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        unlockSensorPositionLatchXminusLayout.setVerticalGroup(
            unlockSensorPositionLatchXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.1;
        add(unlockSensorPositionLatchXminus, gridBagConstraints);

        javax.swing.GroupLayout filterPresenceSensorLatchXminusLayout = new javax.swing.GroupLayout(filterPresenceSensorLatchXminus);
        filterPresenceSensorLatchXminus.setLayout(filterPresenceSensorLatchXminusLayout);
        filterPresenceSensorLatchXminusLayout.setHorizontalGroup(
            filterPresenceSensorLatchXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPresenceSensorLatchXminusLayout.setVerticalGroup(
            filterPresenceSensorLatchXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(filterPresenceSensorLatchXminus, gridBagConstraints);

        javax.swing.GroupLayout filterPresenceSensorLatchXplusLayout = new javax.swing.GroupLayout(filterPresenceSensorLatchXplus);
        filterPresenceSensorLatchXplus.setLayout(filterPresenceSensorLatchXplusLayout);
        filterPresenceSensorLatchXplusLayout.setHorizontalGroup(
            filterPresenceSensorLatchXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPresenceSensorLatchXplusLayout.setVerticalGroup(
            filterPresenceSensorLatchXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(filterPresenceSensorLatchXplus, gridBagConstraints);

        javax.swing.GroupLayout unlockSensorPositionLatchXplusLayout = new javax.swing.GroupLayout(unlockSensorPositionLatchXplus);
        unlockSensorPositionLatchXplus.setLayout(unlockSensorPositionLatchXplusLayout);
        unlockSensorPositionLatchXplusLayout.setHorizontalGroup(
            unlockSensorPositionLatchXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        unlockSensorPositionLatchXplusLayout.setVerticalGroup(
            unlockSensorPositionLatchXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(unlockSensorPositionLatchXplus, gridBagConstraints);

        javax.swing.GroupLayout lockSensorPositionLatchXplusLayout = new javax.swing.GroupLayout(lockSensorPositionLatchXplus);
        lockSensorPositionLatchXplus.setLayout(lockSensorPositionLatchXplusLayout);
        lockSensorPositionLatchXplusLayout.setHorizontalGroup(
            lockSensorPositionLatchXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorPositionLatchXplusLayout.setVerticalGroup(
            lockSensorPositionLatchXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(lockSensorPositionLatchXplus, gridBagConstraints);

        jLabel36.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel36.setText("<html><P align=\"center\">Lock<br>Position</p></html>");
        jLabel36.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 6);
        add(jLabel36, gridBagConstraints);

        jLabel37.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel37.setText("<html><P align=\"center\">Unlock<br>Position</p></html>");
        jLabel37.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        add(jLabel37, gridBagConstraints);

        jLabel40.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel40.setText("<html><P align=\"center\">Filter<br>Engaged</p></html>");
        jLabel40.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 3);
        add(jLabel40, gridBagConstraints);

        lockSensorStateClampXPlusLabel.setFont(new java.awt.Font("Tahoma", 0, 14));
        lockSensorStateClampXPlusLabel.setText("<html><P align=\"center\">Lock</p></html>");
        lockSensorStateClampXPlusLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 19;
        add(lockSensorStateClampXPlusLabel, gridBagConstraints);

        jLabel8.setFont(new java.awt.Font("Tahoma", 1, 18));
        jLabel8.setText("X-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        add(jLabel8, gridBagConstraints);

        javax.swing.GroupLayout filterInAutochangerPanelLayout = new javax.swing.GroupLayout(filterInAutochangerPanel);
        filterInAutochangerPanel.setLayout(filterInAutochangerPanelLayout);
        filterInAutochangerPanelLayout.setHorizontalGroup(
            filterInAutochangerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );
        filterInAutochangerPanelLayout.setVerticalGroup(
            filterInAutochangerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 9;
        add(filterInAutochangerPanel, gridBagConstraints);

        javax.swing.GroupLayout filterInCarouselPanelLayout = new javax.swing.GroupLayout(filterInCarouselPanel);
        filterInCarouselPanel.setLayout(filterInCarouselPanelLayout);
        filterInCarouselPanelLayout.setHorizontalGroup(
            filterInCarouselPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );
        filterInCarouselPanelLayout.setVerticalGroup(
            filterInCarouselPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridheight = 4;
        add(filterInCarouselPanel, gridBagConstraints);

        javax.swing.GroupLayout movementPanelLayout = new javax.swing.GroupLayout(movementPanel);
        movementPanel.setLayout(movementPanelLayout);
        movementPanelLayout.setHorizontalGroup(
            movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 120, Short.MAX_VALUE)
        );
        movementPanelLayout.setVerticalGroup(
            movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 90, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 12;
        add(movementPanel, gridBagConstraints);

        jLabel45.setFont(new java.awt.Font("Tahoma", 1, 18));
        jLabel45.setText("CAROUSEL");
        jLabel45.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 17;
        add(jLabel45, gridBagConstraints);

        jLabel46.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel46.setText("<html><P align=\"right\">Rail Sensor<br>Stand-back Position</p></html>");
        jLabel46.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 60);
        add(jLabel46, gridBagConstraints);

        jLabel47.setFont(new java.awt.Font("Tahoma", 1, 18));
        jLabel47.setText("CHANGER");
        jLabel47.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 11;
        add(jLabel47, gridBagConstraints);

        jLabel33.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel33.setText("<html><P align=\"center\">Unclamping<br>Current</p></html>");
        jLabel33.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        add(jLabel33, gridBagConstraints);

        jLabel48.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel48.setText("<html><P align=\"right\">Rail Sensor<br>Stand-by Position</p></html>");
        jLabel48.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 60);
        add(jLabel48, gridBagConstraints);

        jLabel24.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel24.setText("<html>Rail Sensor<br>Stand-by Position</html>");
        jLabel24.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 60, 0, 0);
        add(jLabel24, gridBagConstraints);

        javax.swing.GroupLayout lockSensorStateClampXMinusSwitchLayout = new javax.swing.GroupLayout(lockSensorStateClampXMinusSwitch);
        lockSensorStateClampXMinusSwitch.setLayout(lockSensorStateClampXMinusSwitchLayout);
        lockSensorStateClampXMinusSwitchLayout.setHorizontalGroup(
            lockSensorStateClampXMinusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorStateClampXMinusSwitchLayout.setVerticalGroup(
            lockSensorStateClampXMinusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 17;
        add(lockSensorStateClampXMinusSwitch, gridBagConstraints);

        javax.swing.GroupLayout filterPositionInClampXMinusSwitchLayout = new javax.swing.GroupLayout(filterPositionInClampXMinusSwitch);
        filterPositionInClampXMinusSwitch.setLayout(filterPositionInClampXMinusSwitchLayout);
        filterPositionInClampXMinusSwitchLayout.setHorizontalGroup(
            filterPositionInClampXMinusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPositionInClampXMinusSwitchLayout.setVerticalGroup(
            filterPositionInClampXMinusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 17;
        add(filterPositionInClampXMinusSwitch, gridBagConstraints);

        javax.swing.GroupLayout filterPositionInClampXPlusSwitchLayout = new javax.swing.GroupLayout(filterPositionInClampXPlusSwitch);
        filterPositionInClampXPlusSwitch.setLayout(filterPositionInClampXPlusSwitchLayout);
        filterPositionInClampXPlusSwitchLayout.setHorizontalGroup(
            filterPositionInClampXPlusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPositionInClampXPlusSwitchLayout.setVerticalGroup(
            filterPositionInClampXPlusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 17;
        add(filterPositionInClampXPlusSwitch, gridBagConstraints);

        javax.swing.GroupLayout lockSensorStateClampXPlusSwitchLayout = new javax.swing.GroupLayout(lockSensorStateClampXPlusSwitch);
        lockSensorStateClampXPlusSwitch.setLayout(lockSensorStateClampXPlusSwitchLayout);
        lockSensorStateClampXPlusSwitchLayout.setHorizontalGroup(
            lockSensorStateClampXPlusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorStateClampXPlusSwitchLayout.setVerticalGroup(
            lockSensorStateClampXPlusSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 17;
        add(lockSensorStateClampXPlusSwitch, gridBagConstraints);

        jLabel42.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel42.setText("<html><P align=\"center\">Filter<br>Engaged</p></html>");
        jLabel42.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 6);
        add(jLabel42, gridBagConstraints);

        filterPositionInClampXPlusLabel.setFont(new java.awt.Font("Tahoma", 0, 14));
        filterPositionInClampXPlusLabel.setText("<html><P align=\"center\">Filter</p></html>");
        filterPositionInClampXPlusLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 19;
        add(filterPositionInClampXPlusLabel, gridBagConstraints);

        lockSensorStateClampXMinusLabel.setFont(new java.awt.Font("Tahoma", 0, 14));
        lockSensorStateClampXMinusLabel.setText("<html><P align=\"center\">Lock</p></html>");
        lockSensorStateClampXMinusLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 19;
        add(lockSensorStateClampXMinusLabel, gridBagConstraints);

        filterPositionInClampXMinusLabel.setFont(new java.awt.Font("Tahoma", 0, 14));
        filterPositionInClampXMinusLabel.setText("<html><P align=\"center\">Filter</p></html>");
        filterPositionInClampXMinusLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 19;
        add(filterPositionInClampXMinusLabel, gridBagConstraints);

        javax.swing.GroupLayout latchActuatorCurrentMeterXminusLayout = new javax.swing.GroupLayout(latchActuatorCurrentMeterXminus);
        latchActuatorCurrentMeterXminus.setLayout(latchActuatorCurrentMeterXminusLayout);
        latchActuatorCurrentMeterXminusLayout.setHorizontalGroup(
            latchActuatorCurrentMeterXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        latchActuatorCurrentMeterXminusLayout.setVerticalGroup(
            latchActuatorCurrentMeterXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        add(latchActuatorCurrentMeterXminus, gridBagConstraints);

        javax.swing.GroupLayout latchActuatorCurrentMeterXplusLayout = new javax.swing.GroupLayout(latchActuatorCurrentMeterXplus);
        latchActuatorCurrentMeterXplus.setLayout(latchActuatorCurrentMeterXplusLayout);
        latchActuatorCurrentMeterXplusLayout.setHorizontalGroup(
            latchActuatorCurrentMeterXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        latchActuatorCurrentMeterXplusLayout.setVerticalGroup(
            latchActuatorCurrentMeterXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        add(latchActuatorCurrentMeterXplus, gridBagConstraints);

        javax.swing.GroupLayout clampActuatorCurrentMeterXminusLayout = new javax.swing.GroupLayout(clampActuatorCurrentMeterXminus);
        clampActuatorCurrentMeterXminus.setLayout(clampActuatorCurrentMeterXminusLayout);
        clampActuatorCurrentMeterXminusLayout.setHorizontalGroup(
            clampActuatorCurrentMeterXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        clampActuatorCurrentMeterXminusLayout.setVerticalGroup(
            clampActuatorCurrentMeterXminusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        add(clampActuatorCurrentMeterXminus, gridBagConstraints);

        javax.swing.GroupLayout clampActuatorCurrentMeterXplusLayout = new javax.swing.GroupLayout(clampActuatorCurrentMeterXplus);
        clampActuatorCurrentMeterXplus.setLayout(clampActuatorCurrentMeterXplusLayout);
        clampActuatorCurrentMeterXplusLayout.setHorizontalGroup(
            clampActuatorCurrentMeterXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        clampActuatorCurrentMeterXplusLayout.setVerticalGroup(
            clampActuatorCurrentMeterXplusLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        add(clampActuatorCurrentMeterXplus, gridBagConstraints);

        jLabel38.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel38.setText("<html><P align=\"center\">Latch control<br>value</p></html>");
        jLabel38.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        add(jLabel38, gridBagConstraints);

        jLabel39.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel39.setText("<html><P align=\"center\">Unclamping<br>Current</p></html>");
        jLabel39.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        add(jLabel39, gridBagConstraints);

        javax.swing.GroupLayout filterPositionInClampXMinusProgressLayout = new javax.swing.GroupLayout(filterPositionInClampXMinusProgress);
        filterPositionInClampXMinusProgress.setLayout(filterPositionInClampXMinusProgressLayout);
        filterPositionInClampXMinusProgressLayout.setHorizontalGroup(
            filterPositionInClampXMinusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 40, Short.MAX_VALUE)
        );
        filterPositionInClampXMinusProgressLayout.setVerticalGroup(
            filterPositionInClampXMinusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        add(filterPositionInClampXMinusProgress, gridBagConstraints);

        javax.swing.GroupLayout filterPositionInClampXPlusProgressLayout = new javax.swing.GroupLayout(filterPositionInClampXPlusProgress);
        filterPositionInClampXPlusProgress.setLayout(filterPositionInClampXPlusProgressLayout);
        filterPositionInClampXPlusProgressLayout.setHorizontalGroup(
            filterPositionInClampXPlusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 40, Short.MAX_VALUE)
        );
        filterPositionInClampXPlusProgressLayout.setVerticalGroup(
            filterPositionInClampXPlusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        add(filterPositionInClampXPlusProgress, gridBagConstraints);

        javax.swing.GroupLayout lockSensorStateClampXMinusProgressLayout = new javax.swing.GroupLayout(lockSensorStateClampXMinusProgress);
        lockSensorStateClampXMinusProgress.setLayout(lockSensorStateClampXMinusProgressLayout);
        lockSensorStateClampXMinusProgressLayout.setHorizontalGroup(
            lockSensorStateClampXMinusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        lockSensorStateClampXMinusProgressLayout.setVerticalGroup(
            lockSensorStateClampXMinusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 50, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        add(lockSensorStateClampXMinusProgress, gridBagConstraints);

        javax.swing.GroupLayout lockSensorStateClampXPlusProgressLayout = new javax.swing.GroupLayout(lockSensorStateClampXPlusProgress);
        lockSensorStateClampXPlusProgress.setLayout(lockSensorStateClampXPlusProgressLayout);
        lockSensorStateClampXPlusProgressLayout.setHorizontalGroup(
            lockSensorStateClampXPlusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        lockSensorStateClampXPlusProgressLayout.setVerticalGroup(
            lockSensorStateClampXPlusProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 50, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        add(lockSensorStateClampXPlusProgress, gridBagConstraints);

        positionSensorXPlusState.setText("No Filter");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 18;
        add(positionSensorXPlusState, gridBagConstraints);

        lockSensorXMinusState.setText("Locked");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        add(lockSensorXMinusState, gridBagConstraints);

        lockSensorXPlusState.setText("Unlocked");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        add(lockSensorXPlusState, gridBagConstraints);

        positionSensorXMinusState.setText("Unknown");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 18;
        add(positionSensorXMinusState, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter clampActuatorCurrentMeterXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter clampActuatorCurrentMeterXplus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel filterInAutochangerPanel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel filterInCarouselPanel;
    private javax.swing.JLabel filterPositionInClampXMinusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar filterPositionInClampXMinusProgress;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch filterPositionInClampXMinusSwitch;
    private javax.swing.JLabel filterPositionInClampXPlusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar filterPositionInClampXPlusProgress;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch filterPositionInClampXPlusSwitch;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch filterPresenceSensorLatchXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch filterPresenceSensorLatchXplus;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel35;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JLabel jLabel45;
    private javax.swing.JLabel jLabel46;
    private javax.swing.JLabel jLabel47;
    private javax.swing.JLabel jLabel48;
    private javax.swing.JLabel jLabel8;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter latchActuatorCurrentMeterXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter latchActuatorCurrentMeterXplus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch lockSensorPositionLatchXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch lockSensorPositionLatchXplus;
    private javax.swing.JLabel lockSensorStateClampXMinusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar lockSensorStateClampXMinusProgress;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch lockSensorStateClampXMinusSwitch;
    private javax.swing.JLabel lockSensorStateClampXPlusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar lockSensorStateClampXPlusProgress;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch lockSensorStateClampXPlusSwitch;
    private javax.swing.JLabel lockSensorXMinusState;
    private javax.swing.JLabel lockSensorXPlusState;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.MovementPanel movementPanel;
    private javax.swing.JLabel positionSensorXMinusState;
    private javax.swing.JLabel positionSensorXPlusState;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch railSensorHandOffPositionXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch railSensorHandOffPositionXplus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch railSensorStandByPositionXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch railSensorStandByPositionXplus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch unlockSensorPositionLatchXminus;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch unlockSensorPositionLatchXplus;
    // End of variables declaration//GEN-END:variables
}
