/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AnalogMeter
extends JPanel {
    int radius = 100;
    int insets = 30;
    Color backgroundColor = new Color(212, 208, 200);
    Color fillColor = new Color(204, 205, 255);
    int minValue = 0;
    int maxValue = 100;
    int value = 0;
    static Random r = new Random();

    public AnalogMeter() {
        this.setPreferredSize(new Dimension(this.radius + 2 * this.insets, this.radius / 2 + (int)(1.5 * (double)this.insets)));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.backgroundColor = bg;
        this.repaint();
    }

    public void setValue(int value) {
        this.value = value;
        this.repaint();
    }

    public void setLimits(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.fillColor);
        g2.fillArc(this.insets, this.insets, this.radius, this.radius, 0, 180);
        g2.setColor(this.backgroundColor);
        g2.fillArc(this.insets + this.radius / 4, this.insets + this.radius / 4, this.radius / 2, this.radius / 2, 0, 180);
        g2.setColor(Color.black);
        g2.drawArc(this.insets, this.insets, this.radius, this.radius, 0, 180);
        g2.drawArc(this.insets + this.radius / 4, this.insets + this.radius / 4, this.radius / 2, this.radius / 2, 0, 180);
        g2.drawLine(this.insets, this.insets + this.radius / 2, this.insets + this.radius / 4, this.insets + this.radius / 2);
        g2.drawLine(this.insets + this.radius * 3 / 4, this.insets + this.radius / 2, this.insets + this.radius, this.insets + this.radius / 2);
        Point center = new Point(this.insets + this.radius / 2, this.insets + this.radius / 2);
        Point tip = new Point(this.insets + this.radius - 1, this.insets + this.radius / 2);
        double rotationAngle = 0.0;
        if (this.value <= this.minValue) {
            rotationAngle = 180.0;
        } else {
            int span = Math.abs(this.maxValue - this.minValue);
            int v = this.value - this.minValue;
            rotationAngle = 180 - v * 180 / span;
        }
        g2.rotate(-rotationAngle * Math.PI / 180.0, this.insets + this.radius / 2, this.insets + this.radius / 2);
        g2.draw(new Line2D.Double(center, tip));
        int[] x = new int[]{this.insets + this.radius, this.insets + this.radius - 8, this.insets + this.radius - 8};
        int[] y = new int[]{this.insets + this.radius / 2, this.insets + this.radius / 2 + 4, this.insets + this.radius / 2 - 4};
        g2.fillPolygon(x, y, 3);
        g2.rotate(rotationAngle * Math.PI / 180.0, this.insets + this.radius / 2, this.insets + this.radius / 2);
        int count = 0;
        int i = 15;
        while (i < 175) {
            int lenght = ++count % 3 == 0 ? 7 : 3;
            Point start = new Point(this.insets + this.radius - lenght, this.insets + this.radius / 2);
            Point end = new Point(this.insets + this.radius - 1, this.insets + this.radius / 2);
            g2.rotate((double)(-i) * Math.PI / 180.0, this.insets + this.radius / 2, this.insets + this.radius / 2);
            g2.draw(new Line2D.Double(start, end));
            g2.rotate((double)i * Math.PI / 180.0, this.insets + this.radius / 2, this.insets + this.radius / 2);
            i += 15;
        }
        g2.setFont(new Font("system", 1, 15));
        String valueStr = String.valueOf(this.value);
        int middleX = this.insets + this.radius / 2;
        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, (int)((double)middleX - bounds.getWidth() / 3.0), this.insets - 3);
        g2.setFont(new Font("system", 1, 10));
        valueStr = String.valueOf(this.minValue);
        bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, (int)((double)this.insets - bounds.getWidth() - 4.0), (int)((double)(this.insets + this.radius / 2) + bounds.getHeight() / 4.0));
        valueStr = String.valueOf(this.maxValue);
        bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, this.insets + this.radius + 4, (int)((double)(this.insets + this.radius / 2) + bounds.getHeight() / 4.0));
    }

    public static void main(String[] argv) {
        AnalogMeter d = new AnalogMeter();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

