package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.BorderLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;

/**
 *
 * @author Tony Johnson
 */
public class CarouselGUISubsystem extends Subsystem {

    private final CarouselModel model;

    CarouselGUISubsystem() {
        model = new CarouselModel();
        Carousel carousel = new Carousel();
        carousel.setModel(model);

        JPanel panel = new JPanel(new BorderLayout());
        panel.add(carousel, BorderLayout.CENTER);
        panel.add(new CarouselModelTestPanel(model), BorderLayout.SOUTH);

        JFrame frame = new JFrame("Carousel Demo");
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        CarouselGUISubsystem t = new CarouselGUISubsystem();
        t.setName("CarouselGUIModule");
        t.setListenToStatus(true);
        t.setStatusBroadcastPeriod(0);
        t.start();
    }

    @Override
    public void onStatus(BusMessage s) {
        System.out.println("CarouselGUI got:" + s);
        if (s instanceof TrendingStatus) {
            TrendingStatus v = (TrendingStatus) s;
            ValueNotification dt = (ValueNotification) v.getValue();
            String thName = s.getOrigin() + "_" + dt.getName();
            long timestamp = dt.gettStamp();
            Object value = dt.getData();
            if (value instanceof StatusDataPublishedByCarousel) {
                final StatusDataPublishedByCarousel status = (StatusDataPublishedByCarousel) value;
                // Update to GUI model must happen on swing thread
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        model.setFilterInCamera(status.getFilterInStandbyName());
                        model.setRotationInDegrees((float) status.getRotationInDegrees());
                        model.setLocked(status.isLocked());
                    }
                });

            }
        }
    }
}
