/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.clamp;

import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;

/**
 *
 * @author turri
 */
public class ClampsTableModel extends DefaultTableModel {
    
    final static String[] colNames = {"Clamp Name", "Clamp State", "Lock Sensor Status","Lock Sensor Value", "Lock Sensor Limits", "Filter Status","Filter Position", "Filter Position Limits"};
    final static Class[] colTypes = {String.class, String.class, String.class,Double.class, String.class, String.class, Double.class, String.class};

    public ClampsTableModel() {
        super(colNames,0);
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return colTypes[columnIndex];
    }


    void addClamp(ClampConfig clampConfig) {
        addRow(new Object[]{clampConfig.getName(),"", "",
            0,clampConfig.getLockSensorValueA()+" - "+clampConfig.getLockSensorValueB(),
            "", 0, 
            clampConfig.getFilterPositionValueA()+" - "+clampConfig.getFilterPositionValueB()+" - "+clampConfig.getFilterPositionValueC()});
    }
    
    public void updateClampStatus(StatusDataPublishedByClamp status) {
        int rows = getRowCount();
        for ( int i = 0; i < rows; i++) {
            if ( getValueAt(i, 0).equals(status.getName()) ) {
                setValueAt(status.getFilterPositionInClamp(), i, 5);
                setValueAt(status.getFilterPositionSensorValue(), i, 6);
                setValueAt(status.getClampState(), i, 1);
                setValueAt(status.getLockStatus(), i, 2);
                setValueAt(status.getLockSensorValue(), i, 3);
                return;
            }
        }
    }
    
}
