package org.lsst.ccs.subsystems.fcs.states;

/**
 * Enumeration representing the power status of the carousel
 *
 * Between filter exchanges, in order to limit the heat in the LSSTCam body, the carousel
 * motors are powered off by putting the carousel in a power save mode. It needs to be waken up
 * before any motion can happen.
 */
public enum CarouselPowerState {
    LOW_POWER, /* The carousel is in power save = cannot move or transmit data */
    REGULAR    /* Normal operational state */
}
