package org.lsst.ccs.subsystems.fcs.states;

/**
 * Enumeration representing the position of the autochanger with respect to gravity
 *
 * The autochanger has two flexible parallel trucks that moves a ~25-40kg filter
 * No matter the telescope azimuth, the autochanger motion must happen with the two trucks at the same level
 * with respect to gravity in order not to prevent them from derailing.
 *
 * This state is directly connected to an inclinometer sensor
 */
public enum AutochangerInclinationState {
    STRAIGHT, /* The trucks are level => allows motion of the autochanger trucks */
    TILTED    /* The trucks are off level => prevents motion of the autochanger trucks */
}
