package org.lsst.ccs.subsystems.fcs;

/**
 * Constants shared by main and GUIs.
 */
public final class FCSCst {

    public static final String PUBLICATION_KEY_FOR_MCM = "fcs/mcm";

    /** Name of the tcpProxy for the autochanger and the carousel*/
    public static final String CHANGER_TCPPROXY_NAME = "canbus0";
    /** Name of the tcpProxy for the loader*/
    public static final String LOADER_TCPPROXY_NAME = "canbus1";
    public static final String LOADER_PLUTOGATEWAY_NAME = "loaderPlutoGateway";
    public static final String LOADER_PLC_DATA_KEY = LOADER_TCPPROXY_NAME + "/" + LOADER_PLUTOGATEWAY_NAME;


    /* Names for loader */
    public static final String LOADER_CLAMP_NAME = "hooks";
    public static final String LOADER_CARRIER_NAME = "carrier";
    public static final String LOADER_NAME = "loader";
    public static final String CARRIER_CONTROLLER_NAME = "carrierController";
    public static final String HOOKS_CONTROLLER_NAME = "hooksController";

    public static final String SOCKET_NAME= "socket";

    /* Names for autochanger*/
    public static final String AC_CLAMPSNAME= "autochanger/onlineClamps";
    public static final String AC_CLAMPXMINUS_NAME = "onlineClampXminus";
    public static final String AC_CLAMPXPLUS_NAME = "onlineClampXplus";
    public static final String AC_CLAMPYMINUS_NAME = "onlineClampYminus";
    public static final String AC_CLAMPXMINUSCONTROLLER_NAME = "onlineClampXminusController";
    public static final String AC_CLAMPXPLUSCONTROLLER_NAME = "onlineClampXplusController";
    public static final String AC_CLAMPYMINUSCONTROLLER_NAME = "onlineClampYminusController";
    public static final String AC_LATCHES_NAME = "latches";
    public static final String AC_LATCHXMINUS_NAME = "latchXminus";
    public static final String AC_LATCHXPLUS_NAME = "latchXplus";
    public static final String AC_LATCHXMINUSCONTROLLER_NAME = "latchXminusController";
    public static final String AC_LATCHXPLUSCONTROLLER_NAME = "latchXplusController";
    public static final String AC_TRUCKXMINUS_NAME = "acTruckXminus";
    public static final String AC_TRUCKXPLUS_NAME = "acTruckXplus";
    public static final String AC_TRUCKXMINUSCONTROLLER_NAME = "acTruckXminusController";
    public static final String AC_TRUCKXPLUSCONTROLLER_NAME = "acTruckXplusController";
    public static final String AC_TRUCKS_NAME= "autochanger/autochangerTrucks";
    /**
     * Name for autochanger gateway where sensors can be read. Used in simulation
     * and tests
     */
    public static final String AC_PLUTOGATEWAY_NAME = "acSensorsGateway";
    public static final String AC_NAME = "autochanger";
    public static final String AC_STRAIN_GAUGE_NAME = "onlineStrainGauge";
    public static final String AC_PLC_DATA_KEY = CHANGER_TCPPROXY_NAME + "/" + AC_PLUTOGATEWAY_NAME;

    /* max number of bytes read on PLUTO gateways by SDO */
    public static final int PLUTOGATEWAY_NB_BYTES = 17;

    /* Names for carousel*/
    public static final String CA_CLAMPXMINUSCONTROLLER_NAME = "clampXminusController";
    public static final String CA_CLAMPXPLUSCONTROLLER_NAME = "clampXplusController";
    public static final String CA_ROTATIONCONTROLLER_NAME = "carouselController";
    public static final String CA_PLC_NAME = "hyttc580";
    public static final String CA_PLC_DATA_KEY = CHANGER_TCPPROXY_NAME + "/" + CA_PLC_NAME + "/plc";

    /*Represents the minimum value which can be returned by an analogic sensor.*/
    public static final int SENSOR14BITS_MIN = 0;

    /*Represents the maximum value which can be returned by an analogic sensor.*/
    public static final int SENSOR14BITS_MAX = 32767;

    /** String literals*/
    public static final String NOT_AT_STANDBY = "NOT AT STANDBY position";
    public static final String AT_STANDBY = "AT STANDBY position";
    public static final String NO_FILTER = "NO FILTER";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String NO_ERROR = "NO ERROR";

    /*Private constructor to hide the implicit public constructor added by Java.*/
    private FCSCst() {
    }
}
