package org.lsst.ccs.subsystems.fcs.states;

/**
 * Enumeration representing the filter status over the course of the survey
 */
public enum ObservatoryFilterState {
    LOADED,        /* filter at ONLINE */
    UNLOADED,      /* system stopped somewhere away from ONLINE (generally either at STANDBY or HANDOFF) */
    UNLOADING,     /* moving from ONLINE to STANDBY */
    LOADING,       /* moving from STANDBY to ONLINE */
    ROTATING,      /* moving the carousel */
    SWAPPING,      /* loading/unloading a filter to/from the camera */
    UNKNOWN        /* edge-case (e.g. at startup) */
}
