
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAccelerometer extends StatusDataPublishedByCanOpenDevice {
    private static final long serialVersionUID = 2L;

    @DataAttributes(description = "Angular velocity along the X axis", units = "deg/s")
    private double angularVelocityX;
    @DataAttributes(description = "Angular velocity along the Y axis", units = "deg/s")
    private double angularVelocityY;
    @DataAttributes(description = "Angular velocity along the Z axis", units = "deg/s")
    private double angularVelocityZ;

    @DataAttributes(description = "Angular acceleration along the X axis", units = "g0")
    private double accelerationX;
    @DataAttributes(description = "Angular acceleration along the Y axis", units = "g0")
    private double accelerationY;
    @DataAttributes(description = "Angular acceleration along the Z axis", units = "g0")
    private double accelerationZ;

    @DataAttributes(description = "Angular acceleration along the X axis in normalized (converted) units", units = "m/s^2")
    private double normalizedAccelerationX;
    @DataAttributes(description = "Angular acceleration along the Y axis in normalized (converted) units", units = "m/s^2")
    private double normalizedAccelerationY;
    @DataAttributes(description = "Angular acceleration along the Z axis in normalized (converted) units", units = "m/s^2")
    private double normalizedAccelerationZ;

    @DataAttributes(description = "Camera body norm of the gravity vector", units = "g0")
    private double gravity = 1;
    @DataAttributes(description = "Camera body norm of the gravity vector in normalized (converted) units", units = "m/s^2")
    private double normalizedGravity = 1;
    @DataAttributes(description = "Camera body elevation from the Z axis", units = "degree")
    private double elevation = 1;
    @DataAttributes(description = "Camera body azimut from the Z axis", units = "degree")
    private double azimut = 0;
    @DataAttributes(description = "Camera body airmass indication", units = "unitless")
    private double airmass = 1;

    public StatusDataPublishedByAccelerometer(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public double getAngularVelocityX() {
        return angularVelocityX;
    }

    public void setAngularVelocityX(double angularVelocityX) {
        this.angularVelocityX = angularVelocityX;
    }

    public double getAngularVelocityY() {
        return angularVelocityY;
    }

    public void setAngularVelocityY(double angularVelocityY) {
        this.angularVelocityY = angularVelocityY;
    }

    public double getAngularVelocityZ() {
        return angularVelocityZ;
    }

    public void setAngularVelocityZ(double angularVelocityZ) {
        this.angularVelocityZ = angularVelocityZ;
    }

    public double getAccelerationX() {
        return accelerationX;
    }

    public void setAccelerationX(double accelerationX) {
        this.accelerationX = accelerationX;
    }

    public double getAccelerationY() {
        return accelerationY;
    }

    public void setAccelerationY(double accelerationY) {
        this.accelerationY = accelerationY;
    }

    public double getAccelerationZ() {
        return accelerationZ;
    }

    public void setAccelerationZ(double accelerationZ) {
        this.accelerationZ = accelerationZ;
    }

    public double getNormalizedAccelerationX() {
        return normalizedAccelerationX;
    }

    public void setNormalizedAccelerationX(double value) {
        this.normalizedAccelerationX = value;
    }

    public double getNormalizedAccelerationY() {
        return normalizedAccelerationY;
    }

    public void setNormalizedAccelerationY(double value) {
        this.normalizedAccelerationY = value;
    }

    public double getNormalizedAccelerationZ() {
        return normalizedAccelerationZ;
    }

    public void setNormalizedAccelerationZ(double value) {
        this.normalizedAccelerationZ = value;
    }

    public double getGravity() {
        return gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public double getNormalizedGravity() {
        return normalizedGravity;
    }

    public void setNormalizedGravity(double value) {
        this.normalizedGravity = value;
    }

    public double getElevation() {
        return elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getAzimut() {
        return azimut;
    }

    public void setAzimut(double azimut) {
        this.azimut = azimut;
    }

    public double getAirmass() {
        return airmass;
    }

    public void setAirmass(double airmass) {
        this.airmass = airmass;
    }
}
