package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * Object published by an Autochanger Online Clamp.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerOnlineClamp implements Serializable {
    private static final long serialVersionUID = -3995677445688405640L;

    @DataAttributes(description = "Autochanger online clamp is locked", units = "unitless")
    private boolean lockSensorOn;
    @DataAttributes(description = "Autochanger online clamp lock sensors in error", units = "unitless")
    private boolean lockSensorInError;

    @DataAttributes(description = "Autochanger online clamp is unlocked", units = "unitless")
    private boolean unlockSensorOn;
    @DataAttributes(description = "Autochanger online clamp unlock sensors in error", units = "unitless")
    private boolean unlockSensorInError;

    @DataAttributes(description = "Autochanger online clamp lock status", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "Autochanger online clamp sensors in error", units = "unitless")
    private boolean inError;

    @DataAttributes(description = "Last current sent to the controller of the autochanger online clamp", units = "mA")
    private int sentCurrent;

    @DataAttributes(description = "Current read on autochanger online clamp controller : index 0x6078", units = "mA")
    private int current;

    @DataAttributes(description = "Autochanger online clamp position read on controller", units = "micron")
    private int position;

    @DataAttributes(description = "Homing of the autochanger online clamp controller is done", units = "unitless")
    @SkipEncoding
    private boolean homingDone;

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorOn() {
        return lockSensorOn;
    }

    public void setLockSensorOn(boolean lockSensorOn) {
        this.lockSensorOn = lockSensorOn;
    }

    public boolean getUnlockSensorOn() {
        return unlockSensorOn;
    }

    public void setUnlockSensorOn(boolean unlockSensorOn) {
        this.unlockSensorOn = unlockSensorOn;
    }

    public boolean isLockSensorInError() {
        return lockSensorInError;
    }

    public void setLockSensorInError(boolean lockSensorInError) {
        this.lockSensorInError = lockSensorInError;
    }

    public boolean isUnlockSensorInError() {
        return unlockSensorInError;
    }

    public void setUnlockSensorInError(boolean unlockSensorInError) {
        this.unlockSensorInError = unlockSensorInError;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public int getSentCurrent() {
        return sentCurrent;
    }

    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

}
