package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.annotations.DataAttributes;

public class StatusDataPublishedByHYTTC580SlipRing extends StatusDataPublishedByHardware {
    private static final long serialVersionUID = 1L;

    @DataAttributes(description = "Output current from the slip ring", units = "mA")
    private int currentSlipRing;

    public StatusDataPublishedByHYTTC580SlipRing(int current) {
        this.currentSlipRing = current;
    }

    public int getCurrentSlipRing() {
        return currentSlipRing;
    }

    public void setCurrentSlipRing(int current) {
        this.currentSlipRing = current;
    }

}
