
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerTwoLatches implements Serializable {
    private static final long serialVersionUID = 8374358651934788527L;

    @DataAttributes(description = "Autochanger latches lockStatus {OPENED; CLOSED; IN_TRAVEL; UNKNOWN; ERROR}", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "Autochanger latches filter presence status {ENGAGED; NO_FILTER; UNKNOWN; ERROR}", units = "unitless")
    private FilterPresenceStatus filterPresenceStatus;

    @DataAttributes(description = "Name of filter on autochanger trucks", units = "unitless")
    private String filterName;

    @DataAttributes(description = "ID of filter on autochanger trucks", units = "unitless")
    private int filterID;

    @DataAttributes(description = "Availability of autochanger", units = "unitless")
    private boolean available;

    public StatusDataPublishedByAutochangerTwoLatches() {
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public int getFilterId() {
        return filterID;
    }

    public void setFilterId(int filterId) {
        this.filterID = filterId;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FilterPresenceStatus getFilterPresenceStatus() {
        return filterPresenceStatus;
    }

    public void setFilterPresenceStatus(FilterPresenceStatus filterPresenceStatus) {
        this.filterPresenceStatus = filterPresenceStatus;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
       return available;
    }
}
