
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 * To publish on the status bus the AutoChangerTrucksModule data.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutoChangerTrucks implements Serializable {
    private static final long serialVersionUID = 8770787257648489652L;

    @DataAttributes(description = "Position of autochanger driver truck along linear rails", units = "micron")
    private int driverPosition = 0;

    @DataAttributes(description = "Position of autochanger follower truck along linear rails", units = "micron")
    private int followerPosition = 0;

    @DataAttributes(description = "Homing on both autochanger truck controllers is done", units = "unitless")
    private boolean homingDone = false;

    /**
     * true if Handoff sensors for TruckXminus and TruckXplus return value 1*
     */
    @DataAttributes(description = "Both autochanger trucks are at handoff position", units = "unitless")
    private boolean atHandoff = false;

    /**
     * true if Online sensors for TruckXminus and TruckXplus return value 1 *
     */
    @DataAttributes(description = "Both autochanger trucks are at online position", units = "unitless")
    private boolean atOnline = false;

    /**
     * true if Standby sensors for TruckXminus and TruckXplus return value 1 *
     */
    @DataAttributes(description = "Both autochanger trucks are at standby position", units = "unitless")
    private boolean atStandby = false;

    /**
     * true if position sensors are in error. *
     */
    @DataAttributes(description = "Autochanger trucks position sensors are in error", units = "unitless")
    private boolean inError = false;

    public int getDriverPosition() {
        return driverPosition;
    }

    public void setDriverPosition(int position) {
        this.driverPosition = position;
    }

    public int getFollowerPosition() {
        return followerPosition;
    }

    public void setFollowerPosition(int followerPosition) {
        this.followerPosition = followerPosition;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean atHandoff) {
        this.atHandoff = atHandoff;
    }

    public boolean isAtOnline() {
        return atOnline;
    }

    public void setAtOnline(boolean atOnline) {
        this.atOnline = atOnline;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

}
