
package org.lsst.ccs.subsystems.fcs;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposState;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
/**
 *
 * @author virieux
 */
public class StatusDataPublishedByEPOSController extends StatusDataPublishedByCanOpenDevice {
    private static final long serialVersionUID = 3257626294501878990L;

    @DataAttributes(description = "EPOS controller mode {HOMING; PROFILE_POSITION; "
        + "PROFILE_VELOCITY; POSITION; MASTER_ENCODER; VELOCITY; CURRENT}", units = "unitless")
    private EposMode mode;

    //only for GUI
    @SkipEncoding
    @DataAttributes(description = "The controller is in charge of brakes", units = "unitless")
    private boolean controllerWithBrake = false;

    @DataAttributes(description = "Brakes activated by the controller if controllerWithBrake is true", units = "unitless")
    private boolean brakeActivated;

    @DataAttributes(description = "State of the EPOS controller {SWITCH_ON_DISABLED; READY_TO_SWITCH_ON; "
        + "SWITCHED_ON; OPERATION_ENABLE; FAULT; QUICKSTOP; UNKNOWN_STATE}", units = "unitless")
    private EposState state;

    @DataAttributes(description = "Current read on controller : index 0x6078", units = "mA")
    private int current;

    @DataAttributes(description = "Position read on controller : index 0x6064 subindex 0", units = "micron")
    private int position;

    @DataAttributes(description = "Velocity read on controller : index 0x2028 subindex 0" , units = "rpm")
    private int velocity;

    @DataAttributes(description = "Value of controller parameter ProfileVelocity : "
            + "index 0x6081 subindex 0. Set to either slowVelocity or fastVelocity", units = "rpm")
    private long profileVelocity;

    @DataAttributes(description = "Value of controller parameter ProfileAcceleration : "
            + "index 0x6083 subindex 0. Set to slowAcceleration or fast acceleration.", units = "rpm/s")
    private long profileAcceleration;

    @DataAttributes(description = "Value of controller parameter ProfileDeceleration "
            + "index 0x6084 subindex 0. Set to slowDeceleration or fastDeceleration.", units = "rpm/s")
    private long profileDeceleration;

    @DataAttributes(description = "Average current read on autochanger truck controller : index 0x2027", units = "mA")
    private int averageCurrent;

    @DataAttributes(description = "Following error read on autochanger truck controller : index 0x20F4", units = "micron")
    private int followingError;

    public StatusDataPublishedByEPOSController(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public StatusDataPublishedByEPOSController(boolean isBooted, boolean isInitialized, boolean inError, String errorRegister, int errorHistoryNB, int lastErrorCode, String lastErrorName) {
        super(isBooted, isInitialized, inError, errorRegister, errorHistoryNB, lastErrorCode, lastErrorName);
    }

    public EposMode getMode() {
        return mode;
    }

    public void setMode(EposMode mode) {
        this.mode = mode;
    }

    public boolean isControllerWithBrake() {
        return controllerWithBrake;
    }

    public void setControllerWithBrake(boolean controllerWithBrake) {
        this.controllerWithBrake = controllerWithBrake;
    }

    public boolean isBrakeActivated() {
        return brakeActivated;
    }

    public void setBrakeActivated(boolean brakeActivated) {
        this.brakeActivated = brakeActivated;
    }

    public EposState getState() {
        return state;
    }

    public void setState(EposState state) {
        this.state = state;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getVelocity() {
        return velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public long getProfileVelocity() {
        return profileVelocity;
    }

    public void setProfileVelocity(long profileVelocity) {
        this.profileVelocity = profileVelocity;
    }

    public long getProfileAcceleration() {
        return profileAcceleration;
    }

    public void setProfileAcceleration(long profileAcceleration) {
        this.profileAcceleration = profileAcceleration;
    }

    public long getProfileDeceleration() {
        return profileDeceleration;
    }

    public void setProfileDeceleration(long profileDeceleration) {
        this.profileDeceleration = profileDeceleration;
    }

    public int getAverageCurrent() {
        return averageCurrent;
    }

    public void setAverageCurrent(int averageCurrent) {
        this.averageCurrent = averageCurrent;
    }

    public int getFollowingError() {
        return followingError;
    }

    public void setFollowingError(int followingError) {
        this.followingError = followingError;
    }
}
