package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 * Temperature data published by HYTTC580:
 * - temperature of each socket of the carousel
 * - average clamp temperature
 * - internal ttc580 temperature
 */
public class StatusDataPublishedByHYTTC580TemperaturesDevices extends StatusDataPublishedByHardware {

    @DataAttributes(description = "Temperature of socket 1", units = "Celsius")
    private final double socket1;

    @DataAttributes(description = "Temperature of socket 2", units = "Celsius")
    private final double socket2;

    @DataAttributes(description = "Temperature of socket 3", units = "Celsius")
    private final double socket3;

    @DataAttributes(description = "Temperature of socket 4", units = "Celsius")
    private final double socket4;

    @DataAttributes(description = "Temperature of socket 5", units = "Celsius")
    private final double socket5;

    @DataAttributes(description = "Average temperature clamps", units = "Celsius")
    private final double averageClamps;

    @DataAttributes(description = "Internal temperature of hyttc580", units = "Celsius")
    private final double internalHYTTC580;

    public StatusDataPublishedByHYTTC580TemperaturesDevices(boolean isBooted, boolean isInitialized, double[] socketTemperatures, double averageClamps, double internalHYTTC580) {
        super(isBooted, isInitialized);
        socket1 = socketTemperatures[0];
        socket2 = socketTemperatures[1];
        socket3 = socketTemperatures[2];
        socket4 = socketTemperatures[3];
        socket5 = socketTemperatures[4];
        this.averageClamps = averageClamps;
        this.internalHYTTC580 = internalHYTTC580;
    }

    public double getAverageClampsTemperature() {
        return averageClamps;
    }

    public double getInternalTemperature() {
        return internalHYTTC580;
    }

    public double getSocketTemperature(int i) {
        switch (i) {
            case 1: return socket1;
            case 2: return socket2;
            case 3: return socket3;
            case 4: return socket4;
            case 5: return socket5;
            default:
                throw new IllegalArgumentException("Socket index must be between 1 and 5, inclusive");
        }
    }
}
