package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerThreeClamps implements Serializable {
    private static final long serialVersionUID = -2447474948055050957L;

    @DataAttributes(description = "Lock status of the autochanger three online clamps "
        + "{OPENED; CLOSED; LOCKED; IN_TRAVEL; UNKNOWN; ERROR}", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "Strain value computed from onlineClampRawStrain "
        + "and Xplus motor temperature. This value corresponds to the deformation "
        + "of the clamp and is used at startup to know if a clamp is closed or locked.", units = "mV")
    private int onlineClampStrain;

    @DataAttributes(description = "Raw strain gauge value read on onlineClampXplus. "
        + "It measures the clamp deformation and is used for the computation "
        + "of the onlineClampStrain value.", units = "mV")
    private int onlineClampRawStrain;

    @DataAttributes(description = "Homing of the three autochanger online clamps is done", units = "unitless")
    @SkipEncoding
    private boolean homingDone;

    public StatusDataPublishedByAutochangerThreeClamps() {
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public int getOnlineClampStrain() {
        return onlineClampStrain;
    }

    public int getOnlineClampRawStrain() {
        return onlineClampRawStrain;
    }


    public void setOnlineClampStrain(int onlineClampStrain) {
        this.onlineClampStrain = onlineClampStrain;
    }

    void setOnlineClampRawStrain(short readStrain) {
        this.onlineClampRawStrain = readStrain;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

}
