
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is thrown when the hardware configuration of a motor is not
 * the same than the software configuration.
 *
 * @author virieux
 */
public class EPOSConfigurationException extends FcsHardwareException {
    private static final long serialVersionUID = 9002755408829355640L;


    /**
     * Creates a new instance of <code>EPOSConfigurationException</code>
     * without detail message.
     */
    public EPOSConfigurationException() {
    }

    public EPOSConfigurationException(String msg) {
        super(msg);
    }




    /**
     * Constructs an instance of <code>EPOSConfigurationException</code> with
     * the specified detail message and the name of the hardware.
     *
     * @param msg the detail message.
     * @param name the hardware name.
     */
    public EPOSConfigurationException(String msg, String name) {
        super(msg, name);
    }



}
