
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAccelerometer extends StatusDataPublishedByCanOpenDevice {
    private static final long serialVersionUID = 2L;

    @DataAttributes(description = "Angular velocity along the X axis", units = "rpm")
    private double angularVelocityX;
    @DataAttributes(description = "Angular velocity along the Y axis", units = "rpm")
    private double angularVelocityY;
    @DataAttributes(description = "Angular velocity along the Z axis", units = "rpm")
    private double angularVelocityZ;

    @DataAttributes(description = "Angular acceleration along the X axis", units = "rpm/s")
    private double accelerationX;
    @DataAttributes(description = "Angular acceleration along the Y axis", units = "rpm/s")
    private double accelerationY;
    @DataAttributes(description = "Angular acceleration along the Z axis", units = "rpm/s")
    private double accelerationZ;

    @DataAttributes(description = "Camera body norm of the gravity vector", units = "unitless")
    private double gravity = 1;
    @DataAttributes(description = "Camera body elevation from the Z axis", units = "degree")
    private double elevation = 1;
    @DataAttributes(description = "Camera body azimut from the Z axis", units = "degree")
    private double azimut = 0;
    @DataAttributes(description = "Camera body airmass indication", units = "unitless")
    private double airmass = 1;

    public StatusDataPublishedByAccelerometer(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public double getAngularVelocityX() {
        return angularVelocityX;
    }

    public void setAngularVelocityX(double angularVelocityX) {
        this.angularVelocityX = angularVelocityX;
    }

    public double getAngularVelocityY() {
        return angularVelocityY;
    }

    public void setAngularVelocityY(double angularVelocityY) {
        this.angularVelocityY = angularVelocityY;
    }

    public double getAngularVelocityZ() {
        return angularVelocityZ;
    }

    public void setAngularVelocityZ(double angularVelocityZ) {
        this.angularVelocityZ = angularVelocityZ;
    }

    public double getAccelerationX() {
        return accelerationX;
    }

    public void setAccelerationX(double accelerationX) {
        this.accelerationX = accelerationX;
    }

    public double getAccelerationY() {
        return accelerationY;
    }

    public void setAccelerationY(double accelerationY) {
        this.accelerationY = accelerationY;
    }

    public double getAccelerationZ() {
        return accelerationZ;
    }

    public void setAccelerationZ(double accelerationZ) {
        this.accelerationZ = accelerationZ;
    }

    public double getGravity() {
        return gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public double getElevation() {
        return elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getAzimut() {
        return azimut;
    }

    public void setAzimut(double azimut) {
        this.azimut = azimut;
    }

    public double getAirmass() {
        return airmass;
    }

    public void setAirmass(double airmass) {
        this.airmass = airmass;
    }
}
