
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderHook implements Serializable {
    private static final long serialVersionUID = 8530682890292854677L;

    @DataAttributes(description = "loader hook locked", units = "unitless")
    private boolean lockSensorOn;

    @DataAttributes(description = "loader hook unlocked", units = "unitless")
    private boolean unlockSensorOn;

    @DataAttributes(description = "loader hook sensors in error", units = "unitless")
    private boolean inError;

    @DataAttributes(description = "loader hook lock status {OPENED; CLOSED; IN_TRAVEL; "
        + "UNKNOWN; ERROR}", units = "unitless")
    private LockStatus lockStatus;

    public StatusDataPublishedByLoaderHook(
            boolean lockSensorOn,
            boolean unlockSensorOn,
            boolean inError,
            LockStatus lockStatus) {
        this.lockSensorOn = lockSensorOn;
        this.unlockSensorOn = unlockSensorOn;
        this.inError = inError;
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorOn() {
        return lockSensorOn;
    }

    public boolean getUnlockSensorOn() {
        return unlockSensorOn;
    }

    public boolean isInError() {
        return inError;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }
}
