package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.IOModuleStatus;

/**
 * An object that a Carousel Socket publishes on the STATUS bus for trending data persister and GUIs.
 * @author virieux
 */
public class StatusDataPublishedByCarouselSocket implements Serializable {
    private static final long serialVersionUID = 353558691508364042L;

    @DataAttributes(description = "IO module status for this socket {UNKNOWN_STATUS; "
        + "IS_SOCKET_AT_STANDBY; IS_READY_NOT_IN_POSITION; ERROR_READING_POSITION; "
        + "SAFE_STATE; BOOTING; NOT_POWERED_ON; NOT_WORKING_FOR_OTHER_REASON}", units = "unitless")
    private IOModuleStatus ioStatus;

    @DataAttributes(description = "socket is at standby position", units = "unitless")
    private boolean atStandby;

    @DataAttributes(description = "clamps state on this socket {READYTOCLAMP; UNCLAMPEDONFILTER; "
        + "UNCLAMPEDEMPTY; CLAMPEDONFILTER; UNDEFINED; ERROR; UNLOCKABLE}", units = "unitless")
    private FilterClampState clampsState;

    @DataAttributes(description = "socket is empty : no filter", units = "unitless")
    private boolean empty;

    @DataAttributes(description = "id of the socket", units = "unitless")
    private int socketID;

    @DataAttributes(description = "name of filter in the socket", units = "unitless")
    private String filterName;

    @SkipEncoding
    @DataAttributes(description = "id of filter in the socket", units = "unitless")
    private int filterID;

    // TODO check units and description
    @SkipEncoding
    private boolean available;

    public IOModuleStatus getIOStatus() {
        return ioStatus;
    }

    public void setIOStatus(IOModuleStatus ioStatus) {
        this.ioStatus = ioStatus;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public FilterClampState getClampState() {
        return clampsState;
    }

    public void setClampsState(FilterClampState clampState) {
        this.clampsState = clampState;
    }

    public boolean isEmpty() {
        return empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public int getFilterID() {
        return filterID;
    }

    public void setFilterID(int filterID) {
        this.filterID = filterID;
    }

    public int getSocketID() {
        return socketID;
    }

    public void setSocketID(int socketID) {
        this.socketID = socketID;
    }

    public boolean isAvailable() {
        return available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }
}
