
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * The data published on the Status Bus by a latch. A latch is what holds a
 * filter on an autochanger truck.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerLatch implements Serializable {
    private static final long serialVersionUID = 2306413555514158111L;

    @DataAttributes(description = "autochanger latch is locked", units = "unitless")
    private boolean lockSensorOn = false;
    @DataAttributes(description = "autochanger latch lock sensors are in error", units = "unitless")
    private boolean lockSensorsInError;

    @DataAttributes(description = "autochanger latch is unlocked", units = "unitless")
    private boolean unlockSensorOn = false;
    @DataAttributes(description = "are the autochanger latch unlock sensors in error", units = "unitless")
    private boolean unlockSensorsInError;

    @DataAttributes(description = "autochanger latch lock status {OPENED; CLOSED; IN_TRAVEL; ERROR; UNKNOWN}", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "filter is detected by the autochanger latch sensors", units = "unitless")
    private boolean filterPresenceSensorOn = false;

    @DataAttributes(description = "autochanger latch sensors are in error", units = "unitless")
    private boolean inError;

    @DataAttributes(description = "autochanger latch filter engaged sensors are in error", units = "unitless")
    private boolean filterEngagedSensorsInError;

    public StatusDataPublishedByAutochangerLatch() {
        lockStatus = LockStatus.UNKNOWN;
    }

    public boolean getFilterPresenceSensorOn() {
        return filterPresenceSensorOn;
    }

    public void setFilterPresenceSensorOn(boolean filterPositionSensorOn) {
        this.filterPresenceSensorOn = filterPositionSensorOn;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorOn() {
        return lockSensorOn;
    }

    public void setLockSensorOn(boolean lockSensorOn) {
        this.lockSensorOn = lockSensorOn;
    }

    public boolean getUnlockSensorOn() {
        return unlockSensorOn;
    }

    public void setUnlockSensorOn(boolean unlockSensorOn) {
        this.unlockSensorOn = unlockSensorOn;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public boolean isLockSensorsInError() {
        return lockSensorsInError;
    }

    public void setLockSensorsInError(boolean lockSensorsInError) {
        this.lockSensorsInError = lockSensorsInError;
    }

    public boolean isUnlockSensorsInError() {
        return unlockSensorsInError;
    }

    public void setUnlockSensorsInError(boolean unlockSensorsInError) {
        this.unlockSensorsInError = unlockSensorsInError;
    }

    public boolean isFilterEngagedSensorsInError() {
        return filterEngagedSensorsInError;
    }

    public void setFilterEngagedSensorsInError(boolean filterEngagedSensorsValue) {
        this.filterEngagedSensorsInError = filterEngagedSensorsValue;
    }

}
