
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderCarrier implements Serializable {
    private static final long serialVersionUID = 3990208459528035053L;

    private boolean atStorage;
    private boolean atHandoff;
    /* at engaged : engagedSensor is ON AND position is arount engaged position */
    private boolean atEngaged;
    private boolean controllerInError;

    @SkipEncoding
    private boolean homingDone;

    private boolean engagedSensorOn;

    public StatusDataPublishedByLoaderCarrier() {
    }

    public boolean isInError() {
        return controllerInError;
    }

    public boolean isAtStorage() {
        return atStorage;
    }

    public void setAtStorage(boolean storageSensorValue0) {
        this.atStorage = storageSensorValue0;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean handoffSensorValue0) {
        this.atHandoff = handoffSensorValue0;
    }


    public boolean isAtEngaged() {
        return atEngaged;
    }

    public void setAtEngaged(boolean engagedSensorValue0) {
        this.atEngaged = engagedSensorValue0;
    }

    public boolean isControllerInError() {
        return controllerInError;
    }

    public void setControllerInError(boolean controllerInError) {
        this.controllerInError = controllerInError;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public boolean isEngagedSensorOn() {
        return engagedSensorOn;
    }

    public void setEngagedSensorOn(boolean engagedSensorOn) {
        this.engagedSensorOn = engagedSensorOn;
    }

}
