
package org.lsst.ccs.subsystems.fcs;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposState;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
/**
 *
 * @author virieux
 */
public class StatusDataPublishedByEPOSController extends StatusDataPublishedByCanOpenDevice {
    private static final long serialVersionUID = 3257626294501878990L;

    private EposMode mode;
    private boolean controllerWithBrake = false;
    private boolean brakeActivated;
    private EposState state;
    
    @DataAttributes(description = "actual current read on controller : index 0x6078", units = "mA")
    private int current;

    @DataAttributes(description = "position read on controller : index:0x6064 subindex:0", units = "mA")
    private int position;
    
    @DataAttributes(description = "velocity read on controller : index 0x2028 subindex 0 [rpm]" , units = "unitless")
    private int velocity;

    @DataAttributes(description = "value of controller parameter ProfileVelocity : "
            + "index 0x6081 subindex 0. In slow mode this field is set to slowVelocity."
            + "In fast mode to fastVelocity. [rpm]", units = "unitless")
    private long profileVelocity;

    @DataAttributes(description = "value of controller parameter ProfileAcceleration : "
            + "index 0x6083 subindex 0. In slow mode this field is set to slowAcceleration."
            + "In fast mode it is set to fast acceleration. [rpm/s]", units = "unitless")
    private long profileAcceleration;

    @DataAttributes(description = "value of controller parameter ProfileDeceleration "
            + "index 0x6084 subindex 0. In slow mode this field is set to slowDeceleration."
            + "In fast mode to fastDeceleration. [rpm/s]", units = "unitless")
    private long profileDeceleration;
    
    @DataAttributes(description = "average current read on AC truck controller : index 0x2027", units = "mA")
    private int averageCurrent;

    @DataAttributes(description = "following error read on AC truck controller : index 0x20F4", units = "micron")
    private int followingError;
    
    public StatusDataPublishedByEPOSController(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public StatusDataPublishedByEPOSController(boolean isBooted, boolean isInitialized, boolean inError, String errorRegister, int errorHistoryNB, int lastErrorCode, String lastErrorName) {
        super(isBooted, isInitialized, inError, errorRegister, errorHistoryNB, lastErrorCode, lastErrorName);
    }

    public EposMode getMode() {
        return mode;
    }

    public void setMode(EposMode mode) {
        this.mode = mode;
    }

    public boolean isControllerWithBrake() {
        return controllerWithBrake;
    }

    public void setControllerWithBrake(boolean controllerWithBrake) {
        this.controllerWithBrake = controllerWithBrake;
    }

    public boolean isBrakeActivated() {
        return brakeActivated;
    }

    public void setBrakeActivated(boolean brakeActivated) {
        this.brakeActivated = brakeActivated;
    }

    public EposState getState() {
        return state;
    }

    public void setState(EposState state) {
        this.state = state;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getVelocity() {
        return velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public long getProfileVelocity() {
        return profileVelocity;
    }

    public void setProfileVelocity(long profileVelocity) {
        this.profileVelocity = profileVelocity;
    }

    public long getProfileAcceleration() {
        return profileAcceleration;
    }

    public void setProfileAcceleration(long profileAcceleration) {
        this.profileAcceleration = profileAcceleration;
    }

    public long getProfileDeceleration() {
        return profileDeceleration;
    }

    public void setProfileDeceleration(long profileDeceleration) {
        this.profileDeceleration = profileDeceleration;
    }
    
    public int getAverageCurrent() {
        return averageCurrent;
    }

    public void setAverageCurrent(int averageCurrent) {
        this.averageCurrent = averageCurrent;
    }

    public int getFollowingError() {
        return followingError;
    }

    public void setFollowingError(int followingError) {
        this.followingError = followingError;
    }
}
