package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *
 * A structure for the data published on the status bus by the Carousel.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarousel implements Serializable {

    private static final long serialVersionUID = 7037058370873652888L;

    @SkipEncoding
    private int position;
    
    private int estimatedPosition;

    @SkipEncoding
    private int deltaPositionAtStandby;

    private boolean atStandby;
    private boolean emptyAtStandby;

    @SkipEncoding
    private boolean moving;

    @SkipEncoding
    private int positionSensorType;

    @SkipEncoding
    private long rotationTimeout;

    @SkipEncoding
    private String filterAtStandbyName;

    @DataAttributes(description = "id of filter at STANDBY position", units = "unitless")
    private int filterAtStandbyId;

    @DataAttributes(description = "name of socket at STANDBY position", units = "unitless")
    private String socketAtStandbyName;

    @DataAttributes(description = "id of socket at STANDBY position", units = "unitless")
    private int socketAtStandbyID;
    
    private long minLocked;

    private long meanClampsTemperature;

    /* just for GUI */
    private FcsEnumerations.IOModuleStatus ioStatusAtStandby;

    /* just for GUI */
    private FcsEnumerations.FilterClampState clampsStateAtStandby;

    @DataAttributes(description = "name of filter on AC trucks", units = "unitless")
    private String filterOnAutochangerName;


    /**
     * To create a new StatusDataPublishedByCarousel with default values.
     */
    public StatusDataPublishedByCarousel() {
        position = 0;
        filterAtStandbyName = "none";
    }

    public int getPosition() {
        return position;
    }

    public int getDeltaPositionAtStandby() {
        return deltaPositionAtStandby;
    }

    public void setDeltaPositionAtStandby(int deltaPositionAtStandby) {
        this.deltaPositionAtStandby = deltaPositionAtStandby;
    }

    public String getFilterAtStandbyName() {
        return filterAtStandbyName;
    }

    public int getFilterAtStandbyId() {
        return filterAtStandbyId;
    }

    public void setFilterAtStandbyId(int filterAtStandbyId) {
        this.filterAtStandbyId = filterAtStandbyId;
    }

    public void setFilterAtStandbyName(String filterInStandbyName) {
        this.filterAtStandbyName = filterInStandbyName;
    }

    public String getFilterOnAutochangerName() {
        return filterOnAutochangerName;
    }

    public void setFilterOnAutochangerName(String filterOnAutochangerName) {
        this.filterOnAutochangerName = filterOnAutochangerName;
    }

    public String getSocketAtStandbyName() {
        return socketAtStandbyName;
    }

    public void setSocketAtStandbyName(String socketAtStandbyName) {
        this.socketAtStandbyName = socketAtStandbyName;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getEstimatedPosition() {
        return estimatedPosition;
    }

    public void setEstimatedPosition(int estimatedPosition) {
        this.estimatedPosition = estimatedPosition;
    }

    public int getPositionSensorType() {
        return positionSensorType;
    }

    public void setPositionSensorType(int positionSensorType) {
        this.positionSensorType = positionSensorType;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isEmptyAtStandby() {
        return emptyAtStandby;
    }

    public void setEmptyAtStandby(boolean emptyAtStandby) {
        this.emptyAtStandby = emptyAtStandby;
    }

    public boolean isMoving() {
        return moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public int getSocketAtStandbyID() {
        return socketAtStandbyID;
    }

    public void setSocketAtStandbyID(int socketAtStandbyID) {
        this.socketAtStandbyID = socketAtStandbyID;
    }

    public FcsEnumerations.IOModuleStatus getIOStatusAtStandby() {
        return ioStatusAtStandby;
    }

    public void setIOStatusAtStandby(FcsEnumerations.IOModuleStatus ioStatusAtStandby) {
        this.ioStatusAtStandby = ioStatusAtStandby;
    }

    public FcsEnumerations.FilterClampState getClampsStateAtStandby() {
        return clampsStateAtStandby;
    }

    public void setClampsStateAtStandby(FcsEnumerations.FilterClampState clampsStateAtStandby) {
        this.clampsStateAtStandby = clampsStateAtStandby;
    }

    public long getRotationTimeout() {
        return rotationTimeout;
    }

    public void setRotationTimeout(long rotationTimeout) {
        this.rotationTimeout = rotationTimeout;
    }

    public long getMinLocked() {
        return minLocked;
    }

    public void setMinLocked(long minLocked) {
        this.minLocked = minLocked;
    }

    public long getMeanClampsTemperature() {
        return meanClampsTemperature;
    }

    public void setMeanClampsTemperature(long meanClampsTemperature) {
        this.meanClampsTemperature = meanClampsTemperature;
    }

}
