package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * Object published by an Autochanger Online Clamp.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerOnlineClamp implements Serializable {
    private static final long serialVersionUID = -3995677445688405640L;

    private boolean lockSensorValue;
    private boolean unlockSensorValue;

    @DataAttributes(description = "AC online clamp lock status", units = "unitless")
    private LockStatus lockStatus;
    private boolean lockSensorInError;
    private boolean unlockSensorInError;
    private boolean inError;

    @DataAttributes(description = "last current sent to the controller of this online clamp ", units = "mA")
    private int sentCurrent;

    @SkipEncoding
    private boolean homingDone;

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(boolean lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public boolean getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(boolean unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }

    public boolean isLockSensorInError() {
        return lockSensorInError;
    }

    public void setLockSensorInError(boolean lockSensorInError) {
        this.lockSensorInError = lockSensorInError;
    }

    public boolean isUnlockSensorInError() {
        return unlockSensorInError;
    }

    public void setUnlockSensorInError(boolean unlockSensorInError) {
        this.unlockSensorInError = unlockSensorInError;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public int getSentCurrent() {
        return sentCurrent;
    }

    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

}
