
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 * To publish on the status bus the AutoChangerTrucksModule data.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutoChangerTrucks implements Serializable {
    private static final long serialVersionUID = 8770787257648489652L;

    @DataAttributes(description = "position of AC driver truck along Linear Rails", units = "micron")
    private int driverPosition = 0;

    @DataAttributes(description = "position of AC follower truck along Linear Rails", units = "micron")
    private int followerPosition = 0;

    private boolean homingDone = false;
    
    /**
     * true if Handoff sensors for TruckXminus and TruckXplus return value 1*
     */
    private boolean atHandoff = false;

    /**
     * true if Online sensors for TruckXminus and TruckXplus return value 1 *
     */
    private boolean atOnline = false;

    /**
     * true if Standby sensors for TruckXminus and TruckXplus return value 1 *
     */
    private boolean atStandby = false;  
    
    /**
     * true if position sensors are in error. *
     */
    private boolean inError = false;

    private double proximityVoltage;

    private int proximityDistance;

    public int getDriverPosition() {
        return driverPosition;
    }

    public void setDriverPosition(int position) {
        this.driverPosition = position;
    }

    public int getFollowerPosition() {
        return followerPosition;
    }

    public void setFollowerPosition(int followerPosition) {
        this.followerPosition = followerPosition;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean atHandoff) {
        this.atHandoff = atHandoff;
    }

    public boolean isAtOnline() {
        return atOnline;
    }

    public void setAtOnline(boolean atOnline) {
        this.atOnline = atOnline;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public double getProximityVoltage() {
        return proximityVoltage;
    }

    public void setProximityVoltage(double proximitySensorValue) {
        this.proximityVoltage = proximitySensorValue;
    }

    public int getProximityDistance() {
        return proximityDistance;
    }

    public void setProximityDistance(int proximityDistance) {
        this.proximityDistance = proximityDistance;
    }

}
