package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerThreeClamps implements Serializable {
    private static final long serialVersionUID = -2447474948055050957L;

    @DataAttributes(description = "autochanger three online clamps lockStatus "
        + "{OPENED; CLOSED; LOCKED; IN_TRAVEL; UNKNOWN; ERROR}", units = "unitless")
    private LockStatus lockStatus;

    // TODO check units and description
    @DataAttributes(description = "normalized strain value computed from onlineClampRawStrain "
        + "and Xplus motor temperature. It gives the force on the clamp to know if a clamp is clamped or "
        + "closed. Gauge factor : 2.07 Wheatstone bridge", units = "m/m")
    private int onlineClampStrain;

    // TODO check units and description
    @DataAttributes(description = "raw strain gauge value read on onlineClampXplus. "
        + "It measures the clamps deformation and is used for the computation "
        + "of the onlineClampStrain value.", units = "mV")
    private int onlineClampRawStrain;

    @SkipEncoding
    private boolean homingDone;

    public StatusDataPublishedByAutochangerThreeClamps() {
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public int getOnlineClampStrain() {
        return onlineClampStrain;
    }

    public int getOnlineClampRawStrain() {
        return onlineClampRawStrain;
    }


    public void setOnlineClampStrain(int onlineClampStrain) {
        this.onlineClampStrain = onlineClampStrain;
    }

    void setOnlineClampRawStrain(short readStrain) {
        this.onlineClampRawStrain = readStrain;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

}
