
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderClamp implements Serializable {
    private static final long serialVersionUID = -8379259445875902552L;

    @DataAttributes(description = "loader clamp lock status {CLAMPED; UNCLAMPED; "
        + "CLOSED; OPENED; UNKNOWN; ERROR}", units = "unitless")
    private LockStatus clampState;

    @DataAttributes(description = "voltage returned by loader clamp forceSensor0", units = "mV")
    private int forceSensorVoltage0;

    @DataAttributes(description = "voltage returned by loader clamp forceSensor1", units = "mV")
    private int forceSensorVoltage1;

    @DataAttributes(description = "clamp force sensors – enough force to hold filter", units = "unitless")
    private boolean forceClampedStatus;

    @DataAttributes(description = "clamp force sensors – not enough force to hold filter", units = "unitless")
    private boolean forceUnclampedStatus;

    @DataAttributes(description = "clamp force sensors – filter between engaged and storage position "
        + "but insufficient force to properly hold filter", units = "unitless")
    private boolean forceUnderClampedStatus;

    @DataAttributes(description = "clamp force sensors – too much force on the hooks – "
        + "risk of damaging both the hooks and the filter interfaces", units = "unitless")
    private boolean forceOverClampedStatus;

    @DataAttributes(description = "are all the loader hooks in the CLOSED state", units = "unitless")
    private boolean allHooksInStateCLOSED;

    @DataAttributes(description = "loader clamp force lock status {UNCLAMPED; CLAMPED; "
        + "UNDER_CLAMPED; OVER_CLAMPED; ERROR}", units = "unitless")
    private LockStatus forceStatus;

    @SkipEncoding
    @DataAttributes(description = "is homing of the loader clamp controller done", units = "unitless")
    private boolean homingDone;
    @DataAttributes(description = "is the loader clamp controller in error", units = "unitless")
    private boolean controllerInError;

    // The four hooks are moving as a single entity,
    // therefore the publication must happen at once
    @DataAttributes(description = "status data of the first loader hook", units = "unitless")
    private StatusDataPublishedByLoaderHook statusPublishedByHook1;
    @DataAttributes(description = "status data of the second loader hook", units = "unitless")
    private StatusDataPublishedByLoaderHook statusPublishedByHook2;
    @DataAttributes(description = "status data of the third loader hook", units = "unitless")
    private StatusDataPublishedByLoaderHook statusPublishedByHook3;
    @DataAttributes(description = "status data of the fourth loader hook", units = "unitless")
    private StatusDataPublishedByLoaderHook statusPublishedByHook4;

    public StatusDataPublishedByLoaderClamp() {
    }

    public void setStatusPublishedByHook1(StatusDataPublishedByLoaderHook statusPublishedByHook1) {
        this.statusPublishedByHook1 = statusPublishedByHook1;
    }

    public void setStatusPublishedByHook2(StatusDataPublishedByLoaderHook statusPublishedByHook2) {
        this.statusPublishedByHook2 = statusPublishedByHook2;
    }

    public void setStatusPublishedByHook3(StatusDataPublishedByLoaderHook statusPublishedByHook3) {
        this.statusPublishedByHook3 = statusPublishedByHook3;
    }

    public void setStatusPublishedByHook4(StatusDataPublishedByLoaderHook statusPublishedByHook4) {
        this.statusPublishedByHook4 = statusPublishedByHook4;
    }

    public int getForceSensorVoltage0() {
        return forceSensorVoltage0;
    }

    public void setForceSensorVoltage0(int forceSensorVoltage0) {
        this.forceSensorVoltage0 = forceSensorVoltage0;
    }

    public int getForceSensorVoltage1() {
        return forceSensorVoltage1;
    }

    public void setForceSensorVoltage1(int forceSensorVoltage1) {
        this.forceSensorVoltage1 = forceSensorVoltage1;
    }

    public boolean isForceClampedStatus() {
        return forceClampedStatus;
    }

    public void setForceClampedStatus(boolean forceStatusOn) {
        this.forceClampedStatus = forceStatusOn;
    }

    public boolean isForceUnclampedStatus() {
        return forceUnclampedStatus;
    }

    public void setForceUnclampedStatus(boolean forceUnclampedStatus) {
        this.forceUnclampedStatus = forceUnclampedStatus;
    }

    public boolean isForceUnderClampedStatus() {
        return forceUnderClampedStatus;
    }

    public void setForceUnderClampedStatus(boolean forceUnderClampedStatus) {
        this.forceUnderClampedStatus = forceUnderClampedStatus;
    }

    public boolean isForceOverClampedStatus() {
        return forceOverClampedStatus;
    }

    public void setForceOverClampedStatus(boolean forceOverClampedStatus) {
        this.forceOverClampedStatus = forceOverClampedStatus;
    }



    public LockStatus getForceStatus() {
        return forceStatus;
    }

    public void setForceStatus(LockStatus forceStatus) {
        this.forceStatus = forceStatus;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public LockStatus getClampState() {
        return clampState;
    }

    public void setClampState(LockStatus clampState) {
        this.clampState = clampState;
    }

    public boolean isControllerInError() {
        return controllerInError;
    }

    public void setControllerInError(boolean controllerInError) {
        this.controllerInError = controllerInError;
    }

    public StatusDataPublishedByLoaderHook getStatusPublishedByHook1() {
        return statusPublishedByHook1;
    }

    public StatusDataPublishedByLoaderHook getStatusPublishedByHook2() {
        return statusPublishedByHook2;
    }

    public StatusDataPublishedByLoaderHook getStatusPublishedByHook3() {
        return statusPublishedByHook3;
    }

    public StatusDataPublishedByLoaderHook getStatusPublishedByHook4() {
        return statusPublishedByHook4;
    }

    public boolean isAllHooksInStateCLOSED() {
        return allHooksInStateCLOSED;
    }

    public void setAllHooksInStateCLOSED(boolean allHooksInStateCLOSED) {
        this.allHooksInStateCLOSED = allHooksInStateCLOSED;
    }
}
