package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.IOModuleStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;

/**
 *
 * A structure for the data published on the status bus by the Carousel.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarousel implements Serializable {

    private static final long serialVersionUID = 7037058370873652888L;

    @SkipEncoding
    @DataAttributes(description = "carousel position read on controller", units = "carousel steps")
    private int position;

    // TODO check units and description
    @DataAttributes(description = "carousel estimated position", units = "carousel steps")
    private int estimatedPosition;

    // TODO check units and description
    @DataAttributes(description = "carousel delta position at standby value ", units = "carousel steps")
    private int deltaPositionAtStandby;

    @DataAttributes(description = "is a carousel socket at standby position", units = "unitless")
    private boolean atStandby;

    @DataAttributes(description = "is an empty carousel socket at standby position", units = "unitless")
    private boolean emptyAtStandby;

    @SkipEncoding
    @DataAttributes(description = "is carousel in motion", units = "unitless")
    private boolean moving;

    @SkipEncoding
    @DataAttributes(description = "position sensor type on carousel controller", units = "unitless")
    private int positionSensorType;

    // TODO check units and description
    @SkipEncoding
    @DataAttributes(description = "max time needed for a rotation of two consecutive carousel sockets. "
            + "In slow mode this field is set to slowRotationTimeout. In fast mode to fastRotationTimeout", units = "ms")
    private long rotationTimeout;

    @SkipEncoding
    @DataAttributes(description = "name of filter at STANDBY position", units = "unitless")
    private String filterAtStandbyName;

    @DataAttributes(description = "id of filter at STANDBY position", units = "unitless")
    private int filterAtStandbyId;

    @DataAttributes(description = "name of carousel socket at STANDBY position", units = "unitless")
    private String socketAtStandbyName;

    @DataAttributes(description = "id of carousel socket at STANDBY position", units = "unitless")
    private int socketAtStandbyID;

    @DataAttributes(description = "threshold value corresponding to the carousel clamps locked status as read on TTC580", units = "mV")
    private long minLocked;

    // TODO check units and description
    @SkipEncoding
    @DataAttributes(description = "mean value of the carousel clamps temperature", units = "Celsius")
    private long meanClampsTemperature;

    @SkipEncoding
    @DataAttributes(description = "status of the carousel IO module at Standby", units = "Celsius")
    private IOModuleStatus ioStatusAtStandby;

    /* just for GUI */
    // TODO check for SkipEncoding
    @DataAttributes(description = "state of the clamps for the socket at standby position {READYTOCLAMP; "
        + "UNCLAMPEDONFILTER; UNCLAMPEDEMPTY; CLAMPEDONFILTER; UNDEFINED; ERROR; UNLOCKABLE}", units = "unitless")
    private FilterClampState clampsStateAtStandby;

    @DataAttributes(description = "name of filter on autochanger trucks", units = "unitless")
    private String filterOnAutochangerName;


    /**
     * To create a new StatusDataPublishedByCarousel with default values.
     */
    public StatusDataPublishedByCarousel() {
        position = 0;
        filterAtStandbyName = "none";
    }

    public int getPosition() {
        return position;
    }

    public int getDeltaPositionAtStandby() {
        return deltaPositionAtStandby;
    }

    public void setDeltaPositionAtStandby(int deltaPositionAtStandby) {
        this.deltaPositionAtStandby = deltaPositionAtStandby;
    }

    public String getFilterAtStandbyName() {
        return filterAtStandbyName;
    }

    public int getFilterAtStandbyId() {
        return filterAtStandbyId;
    }

    public void setFilterAtStandbyId(int filterAtStandbyId) {
        this.filterAtStandbyId = filterAtStandbyId;
    }

    public void setFilterAtStandbyName(String filterInStandbyName) {
        this.filterAtStandbyName = filterInStandbyName;
    }

    public String getFilterOnAutochangerName() {
        return filterOnAutochangerName;
    }

    public void setFilterOnAutochangerName(String filterOnAutochangerName) {
        this.filterOnAutochangerName = filterOnAutochangerName;
    }

    public String getSocketAtStandbyName() {
        return socketAtStandbyName;
    }

    public void setSocketAtStandbyName(String socketAtStandbyName) {
        this.socketAtStandbyName = socketAtStandbyName;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getEstimatedPosition() {
        return estimatedPosition;
    }

    public void setEstimatedPosition(int estimatedPosition) {
        this.estimatedPosition = estimatedPosition;
    }

    public int getPositionSensorType() {
        return positionSensorType;
    }

    public void setPositionSensorType(int positionSensorType) {
        this.positionSensorType = positionSensorType;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isEmptyAtStandby() {
        return emptyAtStandby;
    }

    public void setEmptyAtStandby(boolean emptyAtStandby) {
        this.emptyAtStandby = emptyAtStandby;
    }

    public boolean isMoving() {
        return moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public int getSocketAtStandbyID() {
        return socketAtStandbyID;
    }

    public void setSocketAtStandbyID(int socketAtStandbyID) {
        this.socketAtStandbyID = socketAtStandbyID;
    }

    public IOModuleStatus getIOStatusAtStandby() {
        return ioStatusAtStandby;
    }

    public void setIOStatusAtStandby(IOModuleStatus ioStatusAtStandby) {
        this.ioStatusAtStandby = ioStatusAtStandby;
    }

    public FilterClampState getClampsStateAtStandby() {
        return clampsStateAtStandby;
    }

    public void setClampsStateAtStandby(FilterClampState clampsStateAtStandby) {
        this.clampsStateAtStandby = clampsStateAtStandby;
    }

    public long getRotationTimeout() {
        return rotationTimeout;
    }

    public void setRotationTimeout(long rotationTimeout) {
        this.rotationTimeout = rotationTimeout;
    }

    public long getMinLocked() {
        return minLocked;
    }

    public void setMinLocked(long minLocked) {
        this.minLocked = minLocked;
    }

    public long getMeanClampsTemperature() {
        return meanClampsTemperature;
    }

    public void setMeanClampsTemperature(long meanClampsTemperature) {
        this.meanClampsTemperature = meanClampsTemperature;
    }

}
