package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.DoNotTrend;

/**
 * An object to be published by one AC Truck. Publishes position sensors values.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerTruck implements Serializable {

    private static final long serialVersionUID = 6901144161715675251L;

    @DataAttributes(description = "is the autochanger truck at standby position", units = "unitless")
    private boolean standbySensorValue;
    @DataAttributes(description = "is the autochanger truck at handoff position", units = "unitless")
    private boolean handoffSensorValue;
    @DataAttributes(description = "is the autochanger truck at online position", units = "unitless")
    private boolean onlineSensorValue;

    @DataAttributes(description = "are autochanger truck position sensors at standby in error", units = "unitless")
    private boolean standbyInError;
    @DataAttributes(description = "are autochanger truck position sensors at handoff in error", units = "unitless")
    private boolean handoffInError;
    @DataAttributes(description = "are autochanger truck position sensors at online in error", units = "unitless")
    private boolean onlineInError;

    @DoNotTrend
    private int position;


    public boolean getStandbySensorValue() {
        return standbySensorValue;
    }

    public void setStandbySensorValue(boolean standbySensorValue) {
        this.standbySensorValue = standbySensorValue;
    }

    public boolean getHandoffSensorValue() {
        return handoffSensorValue;
    }

    public void setHandoffSensorValue(boolean handoffSensorValue) {
        this.handoffSensorValue = handoffSensorValue;
    }

    public boolean getOnlineSensorValue() {
        return onlineSensorValue;
    }

    public void setOnlineSensorValue(boolean onlineSensorValue) {
        this.onlineSensorValue = onlineSensorValue;
    }

    public boolean isStandbyInError() {
        return standbyInError;
    }

    public void setStandbyInError(boolean standbyInError) {
        this.standbyInError = standbyInError;
    }

    public boolean isHandoffInError() {
        return handoffInError;
    }

    public void setHandoffInError(boolean handoffInError) {
        this.handoffInError = handoffInError;
    }

    public boolean isOnlineInError() {
        return onlineInError;
    }

    public void setOnlineInError(boolean onlineInError) {
        this.onlineInError = onlineInError;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

}
