
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByPlutoGateway extends StatusDataPublishedByHardware {
    private static final long serialVersionUID = 1922942158481562116L;

    @DataAttributes(description = "16 bytes read by the Pluto Gateway", units = "unitless")
    private int[] intValues;

    public StatusDataPublishedByPlutoGateway(boolean isBooted, boolean isInitialized, int[] intValues) {
        super(isBooted, isInitialized);
        this.intValues = intValues.clone();
    }

    public int[] getIntValues() {
        return intValues.clone();
    }

    public void setIntValues(int[] intValues) {
        this.intValues = intValues.clone();
    }

}
