
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * The data published on the Status Bus by a latch. A latch is what holds a
 * filter on an autochanger truck.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerLatch implements Serializable {
    private static final long serialVersionUID = 2306413555514158111L;

    @DataAttributes(description = "is the autochanger latch locked", units = "unitless")
    private boolean lockSensorValue = false;
    @DataAttributes(description = "is the autochanger latch unlocked", units = "unitless")
    private boolean unlockSensorValue = false;
    @DataAttributes(description = "is a filter detected by the autochanger latch sensors", units = "unitless")
    private boolean filterPresenceSensorValue = false;

    @DataAttributes(description = "autochanger latch lockStatus {OPENED; CLOSED; IN_TRAVEL; ERROR; UNKNOWN}", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "are autochanger latch sensors in error", units = "unitless")
    private boolean inError;
    @DataAttributes(description = "are autochanger lock sensors in error", units = "unitless")
    private boolean lockSensorsInError;
    @DataAttributes(description = "are autochanger unlock sensors in error", units = "unitless")
    private boolean unlockSensorsInError;
    @DataAttributes(description = "are autochanger filter engaged sensors in error", units = "unitless")
    private boolean filterEngagedSensorsInError;

    public StatusDataPublishedByAutochangerLatch() {
        lockStatus = LockStatus.UNKNOWN;
    }

    public boolean getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(boolean filterPositionSensorValue) {
        this.filterPresenceSensorValue = filterPositionSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(boolean lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public boolean getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(boolean unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public boolean isLockSensorsInError() {
        return lockSensorsInError;
    }

    public void setLockSensorsInError(boolean lockSensorsInError) {
        this.lockSensorsInError = lockSensorsInError;
    }

    public boolean isUnlockSensorsInError() {
        return unlockSensorsInError;
    }

    public void setUnlockSensorsInError(boolean unlockSensorsInError) {
        this.unlockSensorsInError = unlockSensorsInError;
    }

    public boolean isFilterEngagedSensorsInError() {
        return filterEngagedSensorsInError;
    }

    public void setFilterEngagedSensorsInError(boolean filterEngagedSensorsValue) {
        this.filterEngagedSensorsInError = filterEngagedSensorsValue;
    }

}
