
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderCarrier implements Serializable {
    private static final long serialVersionUID = 3990208459528035053L;

    @DataAttributes(description = "loader carrier at storage position", units = "unitless")
    private boolean atStorage;

    @DataAttributes(description = "loader carrier at handoff position", units = "unitless")
    private boolean atHandoff;

    /* at engaged : engagedSensor is ON AND position is around engaged position */
    @DataAttributes(description = "loader carrier at engaged position", units = "unitless")
    private boolean atEngaged;

    @DataAttributes(description = "loader carrier controller in error", units = "unitless")
    private boolean controllerInError;

    @SkipEncoding
    @DataAttributes(description = "homing of the loader carrier controller done", units = "unitless")
    private boolean homingDone;

    @DataAttributes(description = "loader carrier engaged position sensor on", units = "unitless")
    private boolean engagedSensorOn;

    public StatusDataPublishedByLoaderCarrier() {
    }

    public boolean isInError() {
        return controllerInError;
    }

    public boolean isAtStorage() {
        return atStorage;
    }

    public void setAtStorage(boolean storageSensorValue0) {
        this.atStorage = storageSensorValue0;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean handoffSensorValue0) {
        this.atHandoff = handoffSensorValue0;
    }


    public boolean isAtEngaged() {
        return atEngaged;
    }

    public void setAtEngaged(boolean engagedSensorValue0) {
        this.atEngaged = engagedSensorValue0;
    }

    public boolean isControllerInError() {
        return controllerInError;
    }

    public void setControllerInError(boolean controllerInError) {
        this.controllerInError = controllerInError;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public boolean isEngagedSensorOn() {
        return engagedSensorOn;
    }

    public void setEngagedSensorOn(boolean engagedSensorOn) {
        this.engagedSensorOn = engagedSensorOn;
    }

}
