package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 * An object to publish state of loader sensors :
 * - which detect filter presence on loader
 * - which detect if loader is connected on camera
 * @author virieux
 */
public class StatusDataPublishedByLoader implements Serializable {
    private static final long serialVersionUID = -6570268980297936654L;

    private boolean filterPresenceSensorValue;
    private boolean loaderOnCameraSensorValue;

    private boolean filterPresenceSensorsInError;
    private boolean loaderOnCameraSensorsInError;
    
    /**
     * Camera protection system signals
     */
    private boolean ap2;
    private boolean af0;
    private boolean af1;
    private boolean af3;
    
    private boolean ap2InError;
    private boolean af0InError;
    private boolean af1InError;
    private boolean af3InError;
    
    private boolean keyLock; //or permit
    private boolean keyEng;
    
    private boolean keyLockInError; //or permit
    private boolean keyEngInError;

    /* output signals */
    private boolean lrh;
    private boolean lrhInError;
    private boolean lps;
    private boolean lpsInError;

    /* signals for PLC debug*/
    private boolean lfs;
    private boolean lfd;
    /**
     * end of Camera protection system signals
     */

    private boolean carrierRelayStatus;
    private boolean hooksRelayStatus;
    private boolean safetyBeltPresence;
    private boolean loaderDefaultStatus;
    private boolean filterPositionStatus;
    
    /* distance returned by sensor loaderFilterDistanceSensor */
    private int filterDistance;
    
    public StatusDataPublishedByLoader() {
    }

    public boolean isCarrierRelayStatus() {
        return carrierRelayStatus;
    }

    public void setCarrierRelayStatus(boolean carrierRelayStatus) {
        this.carrierRelayStatus = carrierRelayStatus;
    }

    public boolean isHooksRelayStatus() {
        return hooksRelayStatus;
    }

    public void setHooksRelayStatus(boolean hooksRelayStatus) {
        this.hooksRelayStatus = hooksRelayStatus;
    }

    public boolean isSafetyBeltPresence() {
        return safetyBeltPresence;
    }

    public void setSafetyBeltPresence(boolean loaderSafetyBeltPresenceSensor) {
        this.safetyBeltPresence = loaderSafetyBeltPresenceSensor;
    }

    public boolean isLoaderDefaultStatus() {
        return loaderDefaultStatus;
    }

    public void setLoaderDefaultStatus(boolean loaderDefaultStatus) {
        this.loaderDefaultStatus = loaderDefaultStatus;
    }

    public boolean isFilterPositionStatus() {
        return filterPositionStatus;
    }

    public void setFilterPositionStatus(boolean loaderFilterGoodPositionStatus) {
        this.filterPositionStatus = loaderFilterGoodPositionStatus;
    }

    public boolean getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public boolean isFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(boolean filterPresenceSensorValue) {
        this.filterPresenceSensorValue = filterPresenceSensorValue;
    }

    public boolean isLoaderOnCameraSensorValue() {
        return loaderOnCameraSensorValue;
    }

    public void setLoaderOnCameraSensorValue(boolean loaderOnCameraSensorValue) {
        this.loaderOnCameraSensorValue = loaderOnCameraSensorValue;
    }

    public boolean isFilterPresenceSensorsInError() {
        return filterPresenceSensorsInError;
    }

    public void setFilterPresenceSensorsInError(boolean filterPresenceSensorsInError) {
        this.filterPresenceSensorsInError = filterPresenceSensorsInError;
    }

    public boolean isLoaderOnCameraSensorsInError() {
        return loaderOnCameraSensorsInError;
    }

    public void setLoaderOnCameraSensorsInError(boolean loaderOnCameraSensorsInError) {
        this.loaderOnCameraSensorsInError = loaderOnCameraSensorsInError;
    }

    public boolean isAp2() {
        return ap2;
    }

    public void setAp2(boolean ap2) {
        this.ap2 = ap2;
    }

    public boolean isAf0() {
        return af0;
    }

    public void setAf0(boolean af0) {
        this.af0 = af0;
    }

    public boolean isAf1() {
        return af1;
    }

    public void setAf1(boolean af1) {
        this.af1 = af1;
    }

    public boolean isAf3() {
        return af3;
    }

    public void setAf3(boolean af3) {
        this.af3 = af3;
    }

    public boolean isAp2InError() {
        return ap2InError;
    }

    public void setAp2InError(boolean ap2InError) {
        this.ap2InError = ap2InError;
    }

    public boolean isAf0InError() {
        return af0InError;
    }

    public void setAf0InError(boolean af0InError) {
        this.af0InError = af0InError;
    }

    public boolean isAf1InError() {
        return af1InError;
    }

    public void setAf1InError(boolean af1InError) {
        this.af1InError = af1InError;
    }

    public boolean isAf3InError() {
        return af3InError;
    }

    public void setAf3InError(boolean af3InError) {
        this.af3InError = af3InError;
    }

    public boolean isKeyLock() {
        return keyLock;
    }

    public void setKeyLock(boolean keyLock) {
        this.keyLock = keyLock;
    }

    public boolean isKeyEng() {
        return keyEng;
    }

    public void setKeyEng(boolean keyEng) {
        this.keyEng = keyEng;
    }

    public boolean isKeyLockInError() {
        return keyLockInError;
    }

    public void setKeyLockInError(boolean keyLockInError) {
        this.keyLockInError = keyLockInError;
    }

    public boolean isKeyEngInError() {
        return keyEngInError;
    }

    public void setKeyEngInError(boolean keyEngInError) {
        this.keyEngInError = keyEngInError;
    }

    public boolean isLrh() {
        return lrh;
    }

    public void setLrh(boolean lrh) {
        this.lrh = lrh;
    }

    public boolean isLrhInError() {
        return lrhInError;
    }

    public void setLrhInError(boolean lrhInError) {
        this.lrhInError = lrhInError;
    }

    public boolean isLps() {
        return lps;
    }

    public void setLps(boolean lps) {
        this.lps = lps;
    }

    public boolean isLpsInError() {
        return lpsInError;
    }

    public void setLpsInError(boolean lpsInError) {
        this.lpsInError = lpsInError;
    }

    public int getFilterDistance() {
        return filterDistance;
    }

    public void setFilterDistance(int filterDistance) {
        this.filterDistance = filterDistance;
    }

    public boolean isLfs() {
        return lfs;
    }

    public void setLfs(boolean lfs) {
        this.lfs = lfs;
    }

    public boolean isLfd() {
        return lfd;
    }

    public void setLfd(boolean lfd) {
        this.lfd = lfd;
    }

}
