
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * A structure for the data published on the status bus by the ClampModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarouselClamp implements Serializable {
    private static final long serialVersionUID = 3238914072953604160L;

    @DataAttributes(description = "global clamp state like CLAMPEDONFILTER or READYTOCLAMP", units = "unitless")
    private FilterClampState clampState;

    @DataAttributes(description = "filter presence status like LOCKABLE or ENGAGED", units = "unitless")
    private FilterPresenceStatus filterPresenceStatus;

    @DataAttributes(description = "value returned by filter position sensor", units = "unitless")
    private int filterPositionSensorValue;

    @DataAttributes(description = "lock status of this clamp like LOCKED or UNLOCKED", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "value returned by lock sensor", units = "unitless")
    private int lockSensorValue;

    @DataAttributes(description = "offset1 for lock sensor read on hyttc580", units = "micron")
    private int lockSensorOffset1;

    @DataAttributes(description = "temperature in clamp read on AI814", units = "degrees")
    private double temperature;

    @DataAttributes(description = "offset1 for filter presence sensor read on hyttc580 : if filter presence sensor "
            + "returns a value between 0 and filterPresenceOffset1 then sensor is in error.", units = "micron")
    private int filterPresenceOffset1;

    @DataAttributes(description = "offset2 for filter presence sensor read on hyttc580 : if filter presence sensor "
            + "returns a value between filterPresenceOffset1 and filterPresenceOffset2 then the filter "
            + "is engaged and lockable.", units = "micron")
    private int filterPresenceOffset2;

    @DataAttributes(description = "current read on clamp controller : index 0x6078 subindex 0", units = "mA")

    private int actualCurrent;
    private int velocity;

    private boolean controllerInFault;
    private boolean controllerEnabled;

    //TODO if slaveStatus is not OK (==6 ?) don't publish clamp information
    private boolean slaveStatusOK;

    public StatusDataPublishedByCarouselClamp() {
        clampState = FilterClampState.UNDEFINED;
        filterPresenceStatus = FilterPresenceStatus.UNKNOWN;
        filterPositionSensorValue = 0;
        lockStatus = LockStatus.UNKNOWN;
        lockSensorValue = 0;
        temperature = 0;
    }

    public void setFilterPresenceStatus(FilterPresenceStatus filterPositionInClamp) {
        this.filterPresenceStatus = filterPositionInClamp;
    }

    public void setFilterPositionSensorValue(int filterPositionSensorValue) {
        this.filterPositionSensorValue = filterPositionSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public int getLockSensorOffset1() {
        return lockSensorOffset1;
    }

    public void setLockSensorOffset1(int lockSensorOffset1) {
        this.lockSensorOffset1 = lockSensorOffset1;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return temperature;
    }

    public FilterPresenceStatus getFilterPresenceStatus() {
        return filterPresenceStatus;
    }

    public int getFilterPositionSensorValue() {
        return filterPositionSensorValue;
    }

    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public FilterClampState getClampState() {
        return clampState;
    }

    public void setClampState(FilterClampState clampState) {
        this.clampState = clampState;
    }

    public int getFilterPresenceOffset1() {
        return filterPresenceOffset1;
    }

    public void setFilterPresenceOffset1(int lockSensorValueA) {
        this.filterPresenceOffset1 = lockSensorValueA;
    }

    public int getFilterPresenceOffset2() {
        return filterPresenceOffset2;
    }

    public void setFilterPresenceOffset2(int filterPresenceValueA) {
        this.filterPresenceOffset2 = filterPresenceValueA;
    }

    public int getActualCurrent() {
        return actualCurrent;
    }

    public int getVelocity() {
        return velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public boolean isControllerInFault() {
        return controllerInFault;
    }

    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public boolean isControllerEnabled() {
        return controllerEnabled;
    }

    public void setControllerEnabled(boolean controllerEnabled) {
        this.controllerEnabled = controllerEnabled;
    }

    public void setActualCurrent(int actualCurrent) {
        this.actualCurrent = actualCurrent;
    }

}
