package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerThreeClamps implements Serializable {
    private static final long serialVersionUID = -2447474948055050957L;

    @DataAttributes(description = "lock status of the 3 online clamps", units = "unitless")
    private FcsEnumerations.LockStatus lockStatus;

    @DataAttributes(description = "normalized strain is computed from onlineClampRawStrain "
            + "and temperature and give the force of the clamp to know if a clamp is clamped or "
            + "closed. Gauge factor : 2.07 Wheatstone bridge", units = "mV")
    private int onlineClampStrain;

    @DataAttributes(description = "strain read on onlineClampGauge used for the computation "
            + "of onlineClampStrain. It measures the deformation. The gauge returns a voltage. "
            + "Gauge factor : 2.07 Wheatstone bridge", units = "mV")

    private int onlineClampRawStrain;

    private boolean homingDone;

    public StatusDataPublishedByAutochangerThreeClamps() {
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public int getOnlineClampStrain() {
        return onlineClampStrain;
    }

    public int getOnlineClampRawStrain() {
        return onlineClampRawStrain;
    }


    public void setOnlineClampStrain(int onlineClampStrain) {
        this.onlineClampStrain = onlineClampStrain;
    }

    void setOnlineClampRawStrain(short readStrain) {
        this.onlineClampRawStrain = readStrain;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

}
