
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderCarrier implements Serializable {
    private static final long serialVersionUID = 3990208459528035053L;

    @DataAttributes(description = "loader carrier position", units = "micron")
    private int position;

    @DataAttributes(description = "loader carrier actual velocity read on controller "
            + ": index 0x2028 subindex 0", units = "rpm")
    private int speed;

    @DataAttributes(description = "value of controller parameter ProfileVelocity "
            + ": index 0x6081 subindex 0. In slow mode this field is set to slowSpeed.", units = "10000 rpm/s")
    private long profileVelocity;

    @DataAttributes(description = "value of controller parameter ProfileVelocity "
            + ": index 0x6083 subindex 0. In slow mode this field is set to slowSpeed.", units = "10000 rpm/s")
    private long profileAcceleration;

    @DataAttributes(description = "value of controller parameter ProfileVelocity "
            + ": index 0x6084 subindex 0. In slow mode this field is set to slowSpeed.", units = "10000 rpm/s")
    private long profileDeceleration;

    @DataAttributes(description = "actual current read on loader carrier controller "
            + ": index 0x6078", units = "mA")
    private int current;

    private boolean atStorage;
    private boolean atHandoff;
    private boolean atEngaged;
    private boolean controllerInError;
    private boolean homingDone;

    private boolean limitSwitchDownInError;
    private boolean limitSwitchUpInError;

    public StatusDataPublishedByLoaderCarrier() {
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public long getProfileVelocity() {
        return profileVelocity;
    }

    public void setProfileVelocity(long profileVelocity) {
        this.profileVelocity = profileVelocity;
    }

    public long getProfileAcceleration() {
        return profileAcceleration;
    }

    public void setProfileAcceleration(long profileAcceleration) {
        this.profileAcceleration = profileAcceleration;
    }

    public long getProfileDeceleration() {
        return profileDeceleration;
    }

    public void setProfileDeceleration(long profileDeceleration) {
        this.profileDeceleration = profileDeceleration;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPosition() {
        return position;
    }
    
    public int getSpeed() {
        return speed;
    }

    public int getCurrent() {
        return current;
    }

    public boolean isInError() {
        return controllerInError;
    }

    public boolean isAtStorage() {
        return atStorage;
    }

    public void setAtStorage(boolean storageSensorValue0) {
        this.atStorage = storageSensorValue0;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean handoffSensorValue0) {
        this.atHandoff = handoffSensorValue0;
    }


    public boolean isAtEngaged() {
        return atEngaged;
    }

    public void setAtEngaged(boolean engagedSensorValue0) {
        this.atEngaged = engagedSensorValue0;
    }

    public boolean isControllerInError() {
        return controllerInError;
    }

    public void setControllerInError(boolean controllerInError) {
        this.controllerInError = controllerInError;
    }

    public boolean isLimitSwitchDownInError() {
        return limitSwitchDownInError;
    }

    public void setLimitSwitchDownInError(boolean limitSwitchDownInError) {
        this.limitSwitchDownInError = limitSwitchDownInError;
    }

    public boolean isLimitSwitchUpInError() {
        return limitSwitchUpInError;
    }

    public void setLimitSwitchUpInError(boolean limitSwitchUpInError) {
        this.limitSwitchUpInError = limitSwitchUpInError;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }
}
