package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 *
 * A structure for the data published on the status bus by the Carousel.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarousel implements Serializable {

    private static final long serialVersionUID = 7037058370873652888L;

    @DataAttributes(description = "carousel position; read on controller", units = "micron")
    private int position;
    
    private int estimatedPosition;

    /* just for GUI */
    private int deltaPositionAtStandby;

    private boolean locked;

    private boolean atStandby;
    private boolean emptyAtStandby;
    private boolean moving;

    @DataAttributes(description = "position sensor type on carousel controller", units = "unitless")
    private int positionSensorType;

    @DataAttributes(description = "carousel velocity read on carousel controller", units = "rpm")
    private double velocity;

    @DataAttributes(description = "actual current read on carousel controller : index 0x6078", units = "mA")
    private double current;

    @DataAttributes(description = "value of controller parameter ProfileVelocity : "
            + "index 0x6081 subindex 0. In slow mode this field is set to slowVelocity."
            + "In fast mode to fastVelocity.", units = "10000 rpm/s")
    private long profileVelocity;

    @DataAttributes(description = "value of controller parameter ProfileAcceleration : "
            + "index 0x6083 subindex 0. In slow mode this field is set to slowAcceleration."
            + "In fast mode it is set to fast acceleration.", units = "10000 rpm/s")
    private long profileAcceleration;

    @DataAttributes(description = "value of controller parameter ProfileDeceleration "
            + "index 0x6084 subindex 0. In slow mode this field is set to slowDeceleration."
            + "In fast mode to fastDeceleration.", units = "10000 rpm/s")
    private long profileDeceleration;

    @DataAttributes(description = "max time needed for a rotation of 2 sockets. "
            + "In slow mode this field is set to slowRotationTimeout. In fast mode to fastRotationTimeout", units = "milliseconds")
    private long rotationTimeout;

    @DataAttributes(description = "name of filter at STANDBY position", units = "unitless")
    private String filterAtStandbyName;

    @DataAttributes(description = "name of socket at STANDBY position", units = "unitless")
    private String socketAtStandbyName;

    @DataAttributes(description = "id of socket at STANDBY position", units = "unitless")
    private int socketAtStandbyID;

    /* just for GUI */
    private FcsEnumerations.SlaveModuleStatus slaveStatusAtStandby;

    /* just for GUI */
    private FcsEnumerations.FilterClampState clampsStateAtStandby;

    @DataAttributes(description = "name of filter on AC trucks", units = "unitless")
    private String filterOnAutochangerName;

    @DataAttributes(description = "carousel temperature1", units = "Celsius degrees")
    private long temperature1;

    @DataAttributes(description = "carousel temperature2", units = "Celsius degrees")
    private long temperature2;

    @DataAttributes(description = "carousel temperature3", units = "Celsius degrees")
    private long temperature3;

    @DataAttributes(description = "carousel temperature4", units = "Celsius degrees")
    private long temperature4;

    @DataAttributes(description = "carousel sensor1", units = "unitless")
    private long sensor1;

    @DataAttributes(description = "carousel sensor2", units = "unitless")
    private long sensor2;

    @DataAttributes(description = "carousel sensor3", units = "unitless")
    private long sensor3;

    @DataAttributes(description = "carousel sensor4", units = "unitless")
    private long sensor4;

    @DataAttributes(description = "carousel sensor5", units = "unitless")
    private long sensor5;

    @DataAttributes(description = "carousel sensor6", units = "unitless")
    private long sensor6;

    @DataAttributes(description = "carousel sensor7", units = "unitless")
    private long sensor7;

    @DataAttributes(description = "carousel sensor8", units = "unitless")
    private long sensor8;

    // private boolean ap1;
    // private boolean ap2;
    // private boolean ap3;
    // private boolean af3;
    // private boolean af3InError;
    // private boolean ap1InError;
    // private boolean ap2InError;
    // private boolean ap3InError;


    //Outputs to Auto-Changer interlocks
    private boolean OUT_CF0;
    private boolean OUT_CF1;
    private boolean OUT_CFC;
    private boolean OUT_CS;
    private boolean OUT_CF0_InError;
    private boolean OUT_CF1_InError;
    private boolean OUT_CFC_InError;
    private boolean OUT_CS_InError;

    /**
     * To create a new StatusDataPublishedByCarousel with default values.
     */
    public StatusDataPublishedByCarousel() {
        position = 0;
        locked = false;
        filterAtStandbyName = "none";
    }

    public boolean isLocked() {
        return locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getPosition() {
        return position;
    }

    public int getDeltaPositionAtStandby() {
        return deltaPositionAtStandby;
    }

    public void setDeltaPositionAtStandby(int deltaPositionAtStandby) {
        this.deltaPositionAtStandby = deltaPositionAtStandby;
    }


    public String getFilterAtStandbyName() {
        return filterAtStandbyName;
    }


    public void setFilterAtStandbyName(String filterInStandbyName) {
        this.filterAtStandbyName = filterInStandbyName;
    }

    public String getFilterOnAutochangerName() {
        return filterOnAutochangerName;
    }

    public void setFilterOnAutochangerName(String filterOnAutochangerName) {
        this.filterOnAutochangerName = filterOnAutochangerName;
    }

    public String getSocketAtStandbyName() {
        return socketAtStandbyName;
    }

    public void setSocketAtStandbyName(String socketAtStandbyName) {
        this.socketAtStandbyName = socketAtStandbyName;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getEstimatedPosition() {
        return estimatedPosition;
    }

    public void setEstimatedPosition(int estimatedPosition) {
        this.estimatedPosition = estimatedPosition;
    }

    public int getPositionSensorType() {
        return positionSensorType;
    }

    public void setPositionSensorType(int positionSensorType) {
        this.positionSensorType = positionSensorType;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isEmptyAtStandby() {
        return emptyAtStandby;
    }

    public void setEmptyAtStandby(boolean emptyAtStandby) {
        this.emptyAtStandby = emptyAtStandby;
    }

    public boolean isMoving() {
        return moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public double getVelocity() {
        return velocity;
    }

    public void setVelocity(double speed) {
        this.velocity = speed;
    }

    public double getCurrent() {
        return current;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    public int getSocketAtStandbyID() {
        return socketAtStandbyID;
    }

    public void setSocketAtStandbyID(int socketAtStandbyID) {
        this.socketAtStandbyID = socketAtStandbyID;
    }

    public FcsEnumerations.SlaveModuleStatus getSlaveStatusAtStandby() {
        return slaveStatusAtStandby;
    }

    public void setSlaveStatusAtStandby(FcsEnumerations.SlaveModuleStatus slaveStatusAtStandby) {
        this.slaveStatusAtStandby = slaveStatusAtStandby;
    }

    public FcsEnumerations.FilterClampState getClampsStateAtStandby() {
        return clampsStateAtStandby;
    }

    public void setClampsStateAtStandby(FcsEnumerations.FilterClampState clampsStateAtStandby) {
        this.clampsStateAtStandby = clampsStateAtStandby;
    }


    // public boolean isAp1() {
    //     return ap1;
    // }

    // public void setAp1(boolean ap1) {
    //     this.ap1 = ap1;
    // }

    // public boolean isAp2() {
    //     return ap2;
    // }

    // public void setAp2(boolean ap2) {
    //     this.ap2 = ap2;
    // }

    // public boolean isAp3() {
    //     return ap3;
    // }

    // public void setAp3(boolean ap3) {
    //     this.ap3 = ap3;
    // }

    // public boolean isAf3() {
    //     return af3;
    // }

    // public void setAf3(boolean af3) {
    //     this.af3 = af3;
    // }

    // public boolean isAf3InError() {
    //     return af3InError;
    // }

    // public void setAf3InError(boolean af3InError) {
    //     this.af3InError = af3InError;
    // }

    // public boolean isAp1InError() {
    //     return ap1InError;
    // }

    // public void setAp1InError(boolean ap1InError) {
    //     this.ap1InError = ap1InError;
    // }

    // public boolean isAp2InError() {
    //     return ap2InError;
    // }

    // public void setAp2InError(boolean ap2InError) {
    //     this.ap2InError = ap2InError;
    // }

    // public boolean isAp3InError() {
    //     return ap3InError;
    // }

    // public void setAp3InError(boolean ap3InError) {
    //     this.ap3InError = ap3InError;
    // }

    public long getProfileVelocity() {
        return profileVelocity;
    }

    public void setProfileVelocity(long profileVelocity) {
        this.profileVelocity = profileVelocity;
    }

    public long getProfileAcceleration() {
        return profileAcceleration;
    }

    public void setProfileAcceleration(long profileAcceleration) {
        this.profileAcceleration = profileAcceleration;
    }

    public long getProfileDeceleration() {
        return profileDeceleration;
    }

    public void setProfileDeceleration(long profileDeceleration) {
        this.profileDeceleration = profileDeceleration;
    }

    public long getRotationTimeout() {
        return rotationTimeout;
    }

    public void setRotationTimeout(long rotationTimeout) {
        this.rotationTimeout = rotationTimeout;
    }

    public long getTemperature1() {
        return temperature1;
    }

    public void setTemperature1(long temperature1) {
        this.temperature1 = temperature1;
    }

    public long getTemperature2() {
        return temperature2;
    }

    public void setTemperature2(long temperature2) {
        this.temperature2 = temperature2;
    }

    public long getTemperature3() {
        return temperature3;
    }

    public void setTemperature3(long temperature3) {
        this.temperature3 = temperature3;
    }

    public long getTemperature4() {
        return temperature4;
    }

    public void setTemperature4(long temperature4) {
        this.temperature4 = temperature4;
    }

    public long getSensor1() {
        return sensor1;
    }

    public void setSensor1(long sensor1) {
        this.sensor1 = sensor1;
    }

    public long getSensor2() {
        return sensor2;
    }

    public void setSensor2(long sensor2) {
        this.sensor2 = sensor2;
    }

    public long getSensor3() {
        return sensor3;
    }

    public void setSensor3(long sensor3) {
        this.sensor3 = sensor3;
    }

    public long getSensor4() {
        return sensor4;
    }

    public void setSensor4(long sensor4) {
        this.sensor4 = sensor4;
    }

    public long getSensor5() {
        return sensor5;
    }

    public void setSensor5(long sensor5) {
        this.sensor5 = sensor5;
    }

    public long getSensor6() {
        return sensor6;
    }

    public void setSensor6(long sensor6) {
        this.sensor6 = sensor6;
    }

    public long getSensor7() {
        return sensor7;
    }

    public void setSensor7(long sensor7) {
        this.sensor7 = sensor7;
    }

    public long getSensor8() {
        return sensor8;
    }

    public void setSensor8(long sensor8) {
        this.sensor8 = sensor8;
    }


    public boolean isOUT_CF0() {
        return OUT_CF0;
    }

    public void setOUT_CF0(boolean OUT_CF0) {
        this.OUT_CF0 = OUT_CF0;
    }

    public boolean isOUT_CF1() {
        return OUT_CF1;
    }

    public void setOUT_CF1(boolean OUT_CF1) {
        this.OUT_CF1 = OUT_CF1;
    }

    public boolean isOUT_CFC() {
        return OUT_CFC;
    }

    public void setOUT_CFC(boolean OUT_CFC) {
        this.OUT_CFC = OUT_CFC;
    }

    public boolean isOUT_CS() {
        return OUT_CS;
    }

    public void setOUT_CS(boolean OUT_CS) {
        this.OUT_CS = OUT_CS;
    }

    public boolean isOUT_CF0_InError() {
        return OUT_CF0_InError;
    }

    public void setOUT_CF0_InError(boolean OUT_CF0_InError) {
        this.OUT_CF0_InError = OUT_CF0_InError;
    }

    public boolean isOUT_CF1_InError() {
        return OUT_CF1_InError;
    }

    public void setOUT_CF1_InError(boolean OUT_CF1_InError) {
        this.OUT_CF1_InError = OUT_CF1_InError;
    }

    public boolean isOUT_CFC_InError() {
        return OUT_CFC_InError;
    }

    public void setOUT_CFC_InError(boolean OUT_CFC_InError) {
        this.OUT_CFC_InError = OUT_CFC_InError;
    }

    public boolean isOUT_CS_InError() {
        return OUT_CS_InError;
    }

    public void setOUT_CS_InError(boolean OUT_CS_InError) {
        this.OUT_CS_InError = OUT_CS_InError;
    }


}
