
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerTwoLatches implements Serializable {
    private static final long serialVersionUID = 8374358651934788527L;

    @DataAttributes(description = "AC latch lock status", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "AC latch filter presence status", units = "unitless")
    private FilterPresenceStatus filterPresenceStatus;

    @DataAttributes(description = "name of filter on AC trucks", units = "unitless")
    private String filterName;

    public StatusDataPublishedByAutochangerTwoLatches() {
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FilterPresenceStatus getFilterPresenceStatus() {
        return filterPresenceStatus;
    }

    public void setFilterPresenceStatus(FilterPresenceStatus filterPresenceStatus) {
        this.filterPresenceStatus = filterPresenceStatus;
    }

}
