
package org.lsst.ccs.subsystems.fcs;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposState;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
/**
 *
 * @author virieux
 */
public class StatusDataPublishedByEPOSController extends StatusDataPublishedByCanOpenDevice {
    private static final long serialVersionUID = 3257626294501878990L;

    private boolean enabled;
    private EposMode mode;
    private boolean controllerWithBrake = false;
    private boolean brakeActivated;
    private EposState state;
    private int current;
    private int position;
    private int velocity;

    public StatusDataPublishedByEPOSController(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public StatusDataPublishedByEPOSController(boolean isBooted, boolean isInitialized, boolean inError, String errorRegister, int errorHistoryNB, int lastErrorCode, String lastErrorName) {
        super(isBooted, isInitialized, inError, errorRegister, errorHistoryNB, lastErrorCode, lastErrorName);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EposMode getMode() {
        return mode;
    }

    public void setMode(EposMode mode) {
        this.mode = mode;
    }

    public boolean isControllerWithBrake() {
        return controllerWithBrake;
    }

    public void setControllerWithBrake(boolean controllerWithBrake) {
        this.controllerWithBrake = controllerWithBrake;
    }

    public boolean isBrakeActivated() {
        return brakeActivated;
    }

    public void setBrakeActivated(boolean brakeActivated) {
        this.brakeActivated = brakeActivated;
    }

    public EposState getState() {
        return state;
    }

    public void setState(EposState state) {
        this.state = state;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getVelocity() {
        return velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }
}
