package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.SlaveModuleStatus;

/**
 * An object that a Carousel Socket publishes on the STATUS bus for trending ddata persister and GUIs.
 * @author virieux
 */
public class StatusDataPublishedByCarouselSocket implements Serializable {
    private static final long serialVersionUID = 353558691508364042L;

    @DataAttributes(description = "status of the slave module status for this socket", units = "unitless")
    private SlaveModuleStatus slaveStatus;

    @DataAttributes(description = "true if this socket is at STANDBY", units = "unitless")
    private boolean atStandby;

    @DataAttributes(description = "clamps state on this socket", units = "unitless")
    private FilterClampState clampsState;

    @DataAttributes(description = "true if this socket is empty : no filter", units = "unitless")
    private boolean empty;

    @DataAttributes(description = "id of this socket", units = "unitless")
    private int socketID;

    @DataAttributes(description = "name of filter in this socket", units = "unitless")
    private String filterName;

    @DataAttributes(description = "id of filter in this socket", units = "micron")
    private int filterID;

    @DataAttributes(description = "difference between actual carousel position and carousel "
            + "position when this socket is at STANDBY.", units = "unitless")
    private int deltaPosition;

    private boolean carouselMoving;

    public SlaveModuleStatus getSlaveStatus() {
        return slaveStatus;
    }

    public void setSlaveStatus(SlaveModuleStatus slaveStatus) {
        this.slaveStatus = slaveStatus;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public FcsEnumerations.FilterClampState getClampState() {
        return clampsState;
    }

    public void setClampsState(FcsEnumerations.FilterClampState clampState) {
        this.clampsState = clampState;
    }
    
    public boolean isEmpty() {
        return empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public int getFilterID() {
        return filterID;
    }

    public void setFilterID(int filterID) {
        this.filterID = filterID;
    }

    public int getSocketID() {
        return socketID;
    }

    public void setSocketID(int socketID) {
        this.socketID = socketID;
    }

    public int getDeltaPosition() {
        return deltaPosition;
    }

    public void setDeltaPosition(int deltaPosition) {
        this.deltaPosition = deltaPosition;
    }

    public boolean isCarouselMoving() {
        return carouselMoving;
    }

    public void setCarouselMoving(boolean carouselMoving) {
        this.carouselMoving = carouselMoving;
    }
}
