
package org.lsst.ccs.subsystems.fcs;

/**
 * 
 * Data to be published on the STATUS bus by a CANopen device
 *
 * @author virieux
 */
public class StatusDataPublishedByCanOpenDevice extends StatusDataPublishedByHardware {
    private static final long serialVersionUID = -4729018504834624288L;
    
    private boolean inError;
    private String errorRegister;
    private int errorHistoryNB;
    private int lastErrorCode;
    private String lastErrorName;

    public StatusDataPublishedByCanOpenDevice(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public StatusDataPublishedByCanOpenDevice(boolean isBooted, boolean isInitialized,
            boolean inError, String errorRegister,
            int errorHistoryNB, int lastErrorCode, String lastErrorName
    ) {
        super(isBooted, isInitialized);
        this.inError = inError;
        this.errorRegister = errorRegister;
        this.errorHistoryNB = errorHistoryNB;
        this.lastErrorCode = lastErrorCode;
        this.lastErrorName = lastErrorName;
    }


    public boolean isInError() {
        return inError;
    }


    public String getErrorRegister() {
        return errorRegister;
    }


    public int getErrorHistoryNB() {
        return errorHistoryNB;
    }


    public int getLastErrorCode() {
        return lastErrorCode;
    }


    public String getLastErrorName() {
        return lastErrorName;
    }

}
