package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 * An object to be published by one AC Truck. Publishes position sensors values.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerTruck implements Serializable {

    private static final long serialVersionUID = 6901144161715675251L;

    private String controllerName;
    private boolean standbySensorValue;
    private boolean handoffSensorValue;
    private boolean onlineSensorValue;
    private boolean standbyInError;
    private boolean handoffInError;
    private boolean onlineInError;

    @DataAttributes(description = "position of this AC truck along Linear Rails", units = "micron")
    private int position;

    @DataAttributes(description = "actual current read on AC truck controller : "
            + "index 0x6078", units = "mA")
    private int current;

    @DataAttributes(description = "average current read on AC truck controller : index 0x2027", units = "mA")
    private int averageCurrent;

    @DataAttributes(description = "average velocity read on AC truck controller : index 0x2028", units = "rpm")
    private int averageVelocity;

    @DataAttributes(description = "following error read on AC truck controller : index 0x20F4", units = "micron")
    private int followingError;

    private boolean controllerInFault;

    public String getControllerName() {
        return controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    public boolean getStandbySensorValue() {
        return standbySensorValue;
    }

    public void setStandbySensorValue(boolean standbySensorValue) {
        this.standbySensorValue = standbySensorValue;
    }

    public boolean getHandoffSensorValue() {
        return handoffSensorValue;
    }

    public void setHandoffSensorValue(boolean handoffSensorValue) {
        this.handoffSensorValue = handoffSensorValue;
    }

    public boolean getOnlineSensorValue() {
        return onlineSensorValue;
    }

    public void setOnlineSensorValue(boolean onlineSensorValue) {
        this.onlineSensorValue = onlineSensorValue;
    }

    public boolean isStandbyInError() {
        return standbyInError;
    }

    public void setStandbyInError(boolean standbyInError) {
        this.standbyInError = standbyInError;
    }

    public boolean isHandoffInError() {
        return handoffInError;
    }

    public void setHandoffInError(boolean handoffInError) {
        this.handoffInError = handoffInError;
    }

    public boolean isOnlineInError() {
        return onlineInError;
    }

    public void setOnlineInError(boolean onlineInError) {
        this.onlineInError = onlineInError;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isControllerInFault() {
        return controllerInFault;
    }

    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getAverageCurrent() {
        return averageCurrent;
    }

    public void setAverageCurrent(int averageCurrent) {
        this.averageCurrent = averageCurrent;
    }

    public int getAverageVelocity() {
        return averageVelocity;
    }

    public void setAverageVelocity(int averageVelocity) {
        this.averageVelocity = averageVelocity;
    }

    public int getFollowingError() {
        return followingError;
    }

    public void setFollowingError(int followingError) {
        this.followingError = followingError;
    }

}
