package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 *
 * A structure for the data published on the status bus by the CarouselModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarousel implements Serializable {

    private static final long serialVersionUID = 7037058370873652888L;
    private int position;
    private boolean locked;
    private boolean homingDone;
    private boolean atStandby;
    private double velocity;
    private double current;
    private String filterAtStandbyName;
    private String socketAtStandbyName;
    private int socketAtStandbyID;
    private String filterOnAutochangerName;
    private boolean ap1;
    private boolean ap2;
    private boolean ap3;
    private boolean af3;
    private boolean af3InError;
    private boolean ap1InError;
    private boolean ap2InError;
    private boolean ap3InError;

    /**
     * To create a new StatusDataPublishedByCarousel with default values.
     */
    public StatusDataPublishedByCarousel() {
        position = 0;
        locked = false;
        homingDone = false;
        filterAtStandbyName = "none";
    }

    public boolean isLocked() {
        return locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getPosition() {
        return position;
    }

    public String getFilterAtStandbyName() {
        return filterAtStandbyName;
    }


    public void setFilterAtStandbyName(String filterInStandbyName) {
        this.filterAtStandbyName = filterInStandbyName;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public String getFilterOnAutochangerName() {
        return filterOnAutochangerName;
    }

    public void setFilterOnAutochangerName(String filterOnAutochangerName) {
        this.filterOnAutochangerName = filterOnAutochangerName;
    }

    public String getSocketAtStandbyName() {
        return socketAtStandbyName;
    }

    public void setSocketAtStandbyName(String socketAtStandbyName) {
        this.socketAtStandbyName = socketAtStandbyName;
    }


    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public double getVelocity() {
        return velocity;
    }

    public void setVelocity(double speed) {
        this.velocity = speed;
    }

    public double getCurrent() {
        return current;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    public int getSocketAtStandbyID() {
        return socketAtStandbyID;
    }

    public void setSocketAtStandbyID(int socketAtStandbyID) {
        this.socketAtStandbyID = socketAtStandbyID;
    }

    public boolean isAp1() {
        return ap1;
    }

    public void setAp1(boolean ap1) {
        this.ap1 = ap1;
    }

    public boolean isAp2() {
        return ap2;
    }

    public void setAp2(boolean ap2) {
        this.ap2 = ap2;
    }

    public boolean isAp3() {
        return ap3;
    }

    public void setAp3(boolean ap3) {
        this.ap3 = ap3;
    }

    public boolean isAf3() {
        return af3;
    }

    public void setAf3(boolean af3) {
        this.af3 = af3;
    }

    public boolean isAf3InError() {
        return af3InError;
    }

    public void setAf3InError(boolean af3InError) {
        this.af3InError = af3InError;
    }

    public boolean isAp1InError() {
        return ap1InError;
    }

    public void setAp1InError(boolean ap1InError) {
        this.ap1InError = ap1InError;
    }

    public boolean isAp2InError() {
        return ap2InError;
    }

    public void setAp2InError(boolean ap2InError) {
        this.ap2InError = ap2InError;
    }

    public boolean isAp3InError() {
        return ap3InError;
    }

    public void setAp3InError(boolean ap3InError) {
        this.ap3InError = ap3InError;
    }


}
