
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.AutoChangerTrucksLocation;

/**
 *
 * A structure for the data published on the status bus by a
 * BasicAutoChangerModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByBasicAutoChanger implements Serializable {

    private static final long serialVersionUID = 1L;
    private String filterOnTrucksName;
    private boolean trucksEmpty;
    private AutoChangerTrucksLocation trucksLocation;
    private boolean railSensorStandbackXminusValue;
    private boolean railSensorStandbackXplusValue;
    private boolean railSensorStandbyXminusValue;
    private boolean railSensorStandbyXplusValue;
    private boolean movingToStandby;
    private boolean movingToStandback;

    public StatusDataPublishedByBasicAutoChanger() {

        this.filterOnTrucksName = "none";
        this.trucksEmpty = true;
        this.trucksLocation = AutoChangerTrucksLocation.UNKNOWN;
        this.railSensorStandbackXminusValue = false;
        this.railSensorStandbackXplusValue = false;
        this.railSensorStandbyXminusValue = false;
        this.railSensorStandbyXplusValue = false;
        this.movingToStandback = false;
        this.movingToStandby = false;
    }

    public String getFilterOnTrucksName() {
        return filterOnTrucksName;
    }

    public void setFilterOnTrucksName(String filterOnTrucksName) {
        this.filterOnTrucksName = filterOnTrucksName;
    }

    public boolean isTrucksEmpty() {
        return trucksEmpty;
    }

    public void setTrucksEmpty(boolean trucksEmpty) {
        this.trucksEmpty = trucksEmpty;
    }

    public AutoChangerTrucksLocation getTrucksLocation() {
        return trucksLocation;
    }

    public void setTrucksLocation(AutoChangerTrucksLocation trucksLocation) {
        this.trucksLocation = trucksLocation;
    }

    public boolean getRailSensorStandbackXminusValue() {
        return railSensorStandbackXminusValue;
    }

    public void setRailSensorStandbackXminusValue(boolean railSensorStandbackXminusValue) {
        this.railSensorStandbackXminusValue = railSensorStandbackXminusValue;
    }

    public boolean getRailSensorStandbackXplusValue() {
        return railSensorStandbackXplusValue;
    }

    public void setRailSensorStandbackXplusValue(boolean railSensorStandbackXplusValue) {
        this.railSensorStandbackXplusValue = railSensorStandbackXplusValue;
    }

    public boolean getRailSensorStandbyXminusValue() {
        return railSensorStandbyXminusValue;
    }

    public void setRailSensorStandbyXminusValue(boolean railSensorStandbyXminusValue) {
        this.railSensorStandbyXminusValue = railSensorStandbyXminusValue;
    }

    public boolean getRailSensorStandbyXplusValue() {
        return railSensorStandbyXplusValue;
    }

    public void setRailSensorStandbyXplusValue(boolean railSensorStandbyXplusValue) {
        this.railSensorStandbyXplusValue = railSensorStandbyXplusValue;
    }

    public boolean isMovingToStandback() {
        return movingToStandback;
    }

    public void setMovingToStandback(boolean movingToStandback) {
        this.movingToStandback = movingToStandback;
    }

    public boolean isMovingToStandby() {
        return movingToStandby;
    }

    public void setMovingToStandby(boolean movingToStandby) {
        this.movingToStandby = movingToStandby;
    }

}
