package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 *
 * A structure for the data published on the status bus by the
 * class Autochanger.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByAutoChanger implements Serializable {

    private static final long serialVersionUID = 1L;
    
    //Loader_LPS Loader is connected and at Storage position
    private boolean loaderConnectedSensorValue;
    private boolean loaderConnectedSensorsInError;
    
    //Loader_LRH Loader is holding filter at HANDOFF
    private boolean loader_LRH; 
    private boolean loader_LRH_InError;

    //Carousel signals
    private boolean carouselHoldingFilter;
    private boolean carousel_CS;
    private boolean carousel_CF0;
    private boolean carousel_CF1;
    private boolean carouselHoldingFilterInError;
    private boolean carousel_CS_InError;
    private boolean carousel_CF0_InError;
    private boolean carousel_CF1_InError;
    
    //Local Protection Module signals;
    private boolean enableRailLin1;
    private boolean enableRailLin2;
    private boolean enableClamps;
    private boolean enableLatches;

    //Sensors on AC1 and AC2, not on PROTO
    private boolean loaderPresence;
    private boolean loaderPresenceInError;
    private boolean lockOut;
    private boolean lockOutInError;
    
    //Inclinometers
    private double inclinaisonXminus;
    private double inclinaisonXplus;

    public boolean getLoaderConnectedSensorValue() {
        return loaderConnectedSensorValue;
    }

    public void setLoaderConnectedSensorValue(boolean loaderConnectedSensorValue0) {
        this.loaderConnectedSensorValue = loaderConnectedSensorValue0;
    }

    public boolean isLoaderConnectedSensorsInError() {
        return loaderConnectedSensorsInError;
    }

    public void setLoaderConnectedSensorsInError(boolean loaderConnectedSensorsInError) {
        this.loaderConnectedSensorsInError = loaderConnectedSensorsInError;
    }

    public boolean isCarouselHoldingFilter() {
        return carouselHoldingFilter;
    }

    public void setCarouselHoldingFilter(boolean carouselHoldingFilter) {
        this.carouselHoldingFilter = carouselHoldingFilter;
    }

    public boolean isCarousel_CS() {
        return carousel_CS;
    }

    public void setCarousel_CS(boolean carousel_CS) {
        this.carousel_CS = carousel_CS;
    }

    public boolean isCarousel_CF0() {
        return carousel_CF0;
    }

    public void setCarousel_CF0(boolean carousel_CF0) {
        this.carousel_CF0 = carousel_CF0;
    }

    public boolean isCarousel_CF1() {
        return carousel_CF1;
    }

    public void setCarousel_CF1(boolean carousel_CF1) {
        this.carousel_CF1 = carousel_CF1;
    }

    public boolean isCarouselHoldingFilterInError() {
        return carouselHoldingFilterInError;
    }

    public void setCarouselHoldingFilterInError(boolean carouselHoldingFilterInError) {
        this.carouselHoldingFilterInError = carouselHoldingFilterInError;
    }

    public boolean isCarousel_CS_InError() {
        return carousel_CS_InError;
    }

    public void setCarousel_CS_InError(boolean carousel_CS_InError) {
        this.carousel_CS_InError = carousel_CS_InError;
    }

    public boolean isCarousel_CF0_InError() {
        return carousel_CF0_InError;
    }

    public void setCarousel_CF0_InError(boolean carousel_CF0_InError) {
        this.carousel_CF0_InError = carousel_CF0_InError;
    }

    public boolean isCarousel_CF1_InError() {
        return carousel_CF1_InError;
    }

    public void setCarousel_CF1_InError(boolean carousel_CF1_InError) {
        this.carousel_CF1_InError = carousel_CF1_InError;
    }

    public boolean isLoaderPresence() {
        return loaderPresence;
    }

    public void setLoaderPresence(boolean loaderPresence) {
        this.loaderPresence = loaderPresence;
    }

    public boolean isLoaderPresenceInError() {
        return loaderPresenceInError;
    }

    public void setLoaderPresenceInError(boolean loaderPresenceInError) {
        this.loaderPresenceInError = loaderPresenceInError;
    }

    public boolean isLockOut() {
        return lockOut;
    }

    public void setLockOut(boolean lockOut) {
        this.lockOut = lockOut;
    }

    public boolean isLockOutInError() {
        return lockOutInError;
    }

    public void setLockOutInError(boolean lockOutInError) {
        this.lockOutInError = lockOutInError;
    }

    
    
    public double getInclinaisonXminus() {
        return inclinaisonXminus;
    }

    public void setInclinaisonXminus(double inclinaisonXminus) {
        this.inclinaisonXminus = inclinaisonXminus;
    }

    public double getInclinaisonXplus() {
        return inclinaisonXplus;
    }

    public void setInclinaisonXplus(double inclinaisonXplus) {
        this.inclinaisonXplus = inclinaisonXplus;
    }

    public boolean isLoaderHoldingFilterAtHandoff() {
        return loader_LRH;
    }

    public void setLoaderHoldingFilterAtHandoff(boolean loaderHoldingFilterAtHandoff) {
        this.loader_LRH = loaderHoldingFilterAtHandoff;
    }

    public boolean isLoaderHoldingFilterAtHandoffInError() {
        return loader_LRH_InError;
    }

    public void setLoaderHoldingFilterAtHandoffInError(boolean loaderHoldingFilterAtHandoffInError) {
        this.loader_LRH_InError = loaderHoldingFilterAtHandoffInError;
    }

    public boolean isEnableRailLin1() {
        return enableRailLin1;
    }

    public void setEnableRailLin1(boolean enableRailLin1) {
        this.enableRailLin1 = enableRailLin1;
    }

    public boolean isEnableRailLin2() {
        return enableRailLin2;
    }

    public void setEnableRailLin2(boolean enableRailLin2) {
        this.enableRailLin2 = enableRailLin2;
    }

    public boolean isEnableClamps() {
        return enableClamps;
    }

    public void setEnableClamps(boolean enableClamps) {
        this.enableClamps = enableClamps;
    }

    public boolean isEnableLatches() {
        return enableLatches;
    }

    public void setEnableLatches(boolean enableLatches) {
        this.enableLatches = enableLatches;
    }
}
